<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$free_text 			= $item->params->get('autofill_email', 0) ? JFactory::getUser()->email : '';
$required			= $item->mandatory ? ' required' : '';
?>
<ul class="list-group no-margin-left">
	<li class="list-group-item">
		<?php 
		foreach ($item->responses as $response)
		{
			if(!empty($response->free_text))
			{
				$free_text = $this->escape($response->free_text);
				break;
			}
		}
		?>
		<input type="text" name="free-text-<?php echo $item->id;?>" class="form-control email<?php echo $required;?>" 
			value="<?php echo $free_text;?>" 
			placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER');?>"
			aria-label="<?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER');?>">
	</li>
</ul>