<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$required			= $item->mandatory ? ' required' : '';
$free_text 			= '';
$selected           = false;
$customAnswerPH     = $item->params->get('custom_answer_placeholder', JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER'));
?>
<div class="table-responsive">
	<table class="table table-hover table-striped">
        <tbody>
    		<?php
    		foreach ($item->answers as $answer)
    		{
    			?>
    			<tr>
                    <th>
                        <?php echo $this->escape($answer->title);?>
                    </th>
                    <td>
                        <select size="1" name="answer-<?php echo $item->id.'-'.$answer->id;?>" class="form-control chosen-disabled" <?php echo $required;?>
                        	aria-label="<?php echo $this->escape(strip_tags($answer->title));?>">
                            <option value=""><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SELECT_ANSWER');?></option>
                            <?php 
                            foreach($item->columns as $i=>$column)
                            {
                            	$selected = false;
                            	$rules = '';
                            	
                            	foreach ($item->responses as $response)
                            	{
                            		if(($response->answer_id == $answer->id) && ($response->column_id == $column->id))
                            		{
                            			$selected = true;
                            		}
                            		else if(!empty($response->free_text))
                            		{
                            			$free_text = CjLibUtils::escape($response->free_text);
                            		}
                            	}
                            	
                            	if(isset($item->rule_selected[$answer->id][$column->id]))
                            	{
                            		$rules = ' showitems="'.implode(',', $item->rule_selected[$answer->id][$column->id]).'"';
                            	}
                                ?>
                                <option value="<?php echo $column->id?>" <?php echo $selected ? 'selected="selected"' : '';?><?php echo $rules;?>>
                                	<?php echo $this->escape($column->title)?>
                                </option>
                                <?php
                            }
                            ?>
                        </select>
                    </td>
                </tr>
    			<?php
    		}
    		?>
		</tbody>
	</table>
</div>
<?php
if($item->custom_choice == 1)
{
	?>
	<ul class="list-group no-margin-left">
		<li class="list-group-item">
			<input type="text" name="free-text-<?php echo $item->id;?>" class="form-control" 
				value="<?php echo $free_text;?>" placeholder="<?php echo $customAnswerPH;?>" aria-label="<?php echo $customAnswerPH;?>">
		</li>
	</ul>
	<?php 
}