<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$free_text 			= '';
$required			= $item->mandatory ? ' required' : '';
$customAnswerPH     = $item->params->get('custom_answer_placeholder', JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER'));
?>
<div class="card-body nps">
	<table class="nps-table">
		<thead>
			<tr class="inline text-inline">
				<td><span class="pull-left"><?php echo JText::_('COM_COMMUNITYSURVEYS_NOT_AT_ALL_LIKELY');?></span></td>
				<td><span class="pull-right"><?php echo JText::_('COM_COMMUNITYSURVEYS_EXTREMELY_LIKELY');?></span><td>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td colspan="2">
					<div class="list-group-horizontal" role="radiogroup" aria-label="<?php echo $this->escape(strip_tags($item->title));?>">
						<?php 
						for ($answer = 1; $answer <= 10; $answer++)
						{
							$checked = false;
							$rules = '';
							foreach ($item->responses as $response)
							{
								if($answer == $response->answer_id)
								{
									$checked = true;
								} 
								else if(!empty($response->free_text))
								{
									$free_text = CjLibUtils::escape($response->free_text);
								}
							}
							
							if(isset($item->rule_selected[$answer]))
							{
								$rules = ' showitems="'.implode(',', $item->rule_selected[$answer]).'"';
							}
							?>
							<a href="#" class="list-group-item<?php echo $checked ? ' active' : '';?>" 
								onclick="return false;"
								role="radio"
								aria-checked="<?php echo $checked ? 'true' : 'false';?>"
								aria-describedby="<?php echo $answer;?>">
								<strong><?php echo $answer;?></strong>
								<input 
									type="radio" 
									name="answer-<?php echo $item->id;?>" 
									value="<?php echo $answer;?>"
									autocomplete="off" <?php echo $rules;?>
									class="<?php echo $required;?>" 
									style="display: none;" <?php echo $checked ? ' checked="checked"' : '';?>>
							</a>
							<?php
						}
						?>
					</div>
				</td>
			</tr>
		</tbody>
	</table>
</div>
<?php
if($item->custom_choice == 1)
{
	?>
	<div class="card-footer">
		<input type="text" name="free-text-<?php echo $item->id;?>" class="form-control valid" 
			value="<?php echo $free_text;?>" placeholder="<?php echo $customAnswerPH;?>" aria-required="false" aria-label="<?php echo $customAnswerPH;?>">
	</div>
	<?php
}
?>