<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 	= $displayData['params'];
$item 		= $displayData['item'];
$theme 		= $params->get('theme', 'default');

$layouts = array(
    CS_PAGE_HEADER => 'page_header',
    CS_CHOICE_RADIO => 'choice',
    CS_CHOICE_CHECKBOX => 'choice',
    CS_CHOICE_SELECT => 'choice',
    CS_CHOICE_MULTIRATING => 'multirating',
    CS_CHOICE_NPS => 'nps',
    CS_CHOICE_RANKING => 'ranking',
    CS_CHOICE_SLIDER => 'slider',
    CS_GRID_RADIO => 'grid',
    CS_GRID_CHECKBOX => 'grid',
    CS_FREE_TEXT_SINGLE_LINE => 'textbox',
    CS_FREE_TEXT_MULTILINE => 'textbox',
    CS_FREE_TEXT_PASSWORD => 'textbox',
    CS_FREE_TEXT_RICH_TEXT => 'rich_textbox',
    CS_IMAGE_CHOOSE_IMAGE => 'image',
    CS_IMAGE_CHOOSE_IMAGES => 'image',
    CS_GRID_MATCHING => 'matching',
    CS_FILE_UPLOAD => 'fileupload',
    CS_SPECIAL_NAME => 'name',
    CS_SPECIAL_EMAIL => 'email',
    CS_SPECIAL_CALENDAR => 'calendar',
    CS_SPECIAL_ADDRESS => 'address',
    CS_SPECIAL_SIGNATURE => 'signature'
);
?>
<div id="question-<?php echo $item->id;?>" class="card bg-<?php echo $theme;?> mb-3 qtype-<?php echo $layouts[$item->question_type] . ($item->hidden ? ' hideme' : '');?>">

	<div class="card-header">
		<div class="card-title"><i class="fa fa-caret-right"></i> <?php echo $item->title;?></div>
	</div>
	
	<?php 
	$description = $item->description;
	if(!empty($description))
	{
		?>
		<div class="card-body">
			<?php echo $item->description;?>
		</div>
		<?php
	}
	
	echo $this->sublayout($layouts[$item->question_type], array('item'=>$item, 'params'=>$params));
	?>
</div>