<?php
/**
 * @package     corejoomla.site
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$user 		= JFactory::getUser();

$params 	= $displayData['params'];
$state 		= $displayData['state'];

$category 	= isset($displayData['category']) ? $displayData['category'] : null;
$asset 		= !empty($category) ? 'com_communitysurveys.category.'.$category->id : 'com_communitysurveys';

if($params->get('show_toolbar', 1) == 1)
{
	$allowCreate 	= $user->authorise('core.create', $asset) || count($user->getAuthorisedCategories('com_communitysurveys', 'core.create'));
	$allowRespond	= $user->authorise('core.respond', $asset) || count($user->getAuthorisedCategories('com_communitysurveys', 'core.respond'));
	?>
	
	<?php echo CJFunctions::load_module_position('surveys-above-toolbar');?>
	
	<nav class="navbar navbar-expand-lg navbar-light bg-light mb-3" role="navigation">
		<a class="navbar-brand" href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getSurveysRoute());?>">
			<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_HOME');?>
		</a>
		<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#cs-navbar-collapse" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
			<span class="navbar-toggler-icon"></span>
		</button>
		<div class="collapse navbar-collapse" id="cs-navbar-collapse">
			<ul class="nav navbar-nav mr-auto">
				<li class="dropdown">
					<a href="#" class="nav-link dropdown-toggle" data-toggle="dropdown">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_DISCOVER');?> <b class="caret"></b>
					</a>
					<ul class="dropdown-menu">
						<li class="dropdown-item<?php echo (is_object($state) && $state->get('list.ordering') == 'a.created') ? ' active' : '';?>">
							<a class="nav-link" href="<?php echo CommunitySurveysHelperRoute::getSurveysRoute().'&recent=true';?>">
								<i class="fa fa-tasks"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RECENT_SURVEYS')?>
							</a>
						</li>
						<li class="dropdown-item<?php echo (is_object($state) && $state->get('list.ordering') == 'a.responses') ? 'active' : '';?>">
							<a class="nav-link" href="#" onclick="filterSurveys('', 'a.responses', 'desc', 0); return false;">
								<i class="fa fa-fire"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_POPULAR_SURVEYS')?>
							</a>
						</li>
						<li class="dropdown-divider"></li>
						<li class="dropdown-item">
							<a class="nav-link" href="<?php echo CommunitySurveysHelperRoute::getSearchRoute();?>">
								<i class="fa fa-users"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ADVANCED_SEARCH')?>
							</a>
						</li>
					</ul>
				</li>
			</ul>
			<?php if(!$user->guest && ($allowCreate || $allowRespond)):?>
			<ul class="navbar-nav">
				<?php if($allowCreate):?>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo CommunitySurveysHelperRoute::getFormRoute();?>"><?php echo JText::_('COM_COMMUNITYSURVEYS_CREATE_SURVEY');?></a>
                </li>
                <?php endif;?>
                
				<li class="nav-item dropdown">
					<a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
						<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ACCOUNT');?> <b class="caret"></b>
					</a>
					<ul class="dropdown-menu">
						<?php if($allowCreate):?>
						<li class="dropdown-item">
							<a class="nav-link" href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getMySurveysRoute());?>">
								<i class="fa fa-user"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_MY_SURVEYS');?>
							</a>
						</li>
						<?php endif;?>
						
						<?php if($allowRespond):?>
						<li class="dropdown-item">
							<a class="nav-link" href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getMyResponsesRoute());?>">
								<i class="fa fa-file-o"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_MY_RESPONSES');?>
							</a>
						</li>
						<?php endif?>
					</ul>
				</li>
			</ul>
			<?php endif;?>
		</div>
	</nav>
	<?php 
}
?>

<form id="toolbarAuthorForm" name="toolbarAuthorForm" action="<?php echo JRoute::_('index.php');?>" method="post" style="display: none;">
	<input type="hidden" id="filter_author_id" name="filter_author_id" value="<?php echo $user->id;?>">
	<input type="hidden" id="view" name="view" value="surveys">
</form>

<form id="toolbarFilterForm" name="toolbarFilterForm" action="<?php echo JRoute::_(CommunitySurveysHelperRoute::getSurveysRoute());?>" method="post" style="display: none;">
	<input type="hidden" id="filter_featured" name="filter_featured" value="">
	<input type="hidden" id="filter_order" name="filter_order" value="created">
	<input type="hidden" id="filter_order_Dir" name="filter_order_Dir" value="desc">
	<input type="hidden" id="filter_unanswered" name="filter_unanswered" value="0">
	<input type="hidden" id="view" name="view" value="surveys">
</form>

<script type="text/javascript">
<!--
function filterSurveys(featured, order, direction, unanswered)
{
	document.toolbarFilterForm.filter_featured.value = featured;
	document.toolbarFilterForm.filter_order.value = order;
	document.toolbarFilterForm.filter_order_Dir.value = direction;
	document.toolbarFilterForm.filter_unanswered.value = unanswered;

	document.toolbarFilterForm.submit();
}
//-->
</script>