<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 	= $displayData['params'];
$heading    = $displayData['heading'];

$theme      = $params->get('theme');
?>
<?php if ($params->get('show_page_heading', 1)) : ?>
<h1 class="page-header no-space-top"> <?php echo $this->escape($heading); ?> </h1>
<?php endif; ?>

<div class="alert alert-info"><i class="fa fa-info-circle"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_SEARCH_CRITERIA');?></div>

<form action="<?php echo JRoute::_(CommunitySurveysHelperRoute::getSurveysRoute());?>" method="get">
	
	<div class="panel panel-<?php echo $theme;?>">
		<div class="panel-heading">
			<div class="panel-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_KEYWORDS');?></div>
		</div>
		<div class="panel-body">
		 	<input name="list_filter" type="text" class="span8 col-md-8" placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_KEYWORDS');?>">
		 	<select name="list_filter_field">
		 		<option value="title"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_TITLES');?></option>
		 		<option value="author"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_USER_NAME');?></option>
		 		<option value="createdby"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_USERID');?></option>
		 		<option value="id"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_SURVEY_ID');?></option>
		 	</select>
		 	<label class="checkbox"><input type="checkbox" value="1" name="filter_all_keywords"> <?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_ALL_WORDS');?></label>
		</div>
	</div>
	<div class="row-fluid clearfix">
		<div class="span6 col-md-6">
			<div class="panel panel-<?php echo $theme;?>">
				<div class="panel-heading">
					<div class="panel-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_OPTIONS');?></div>
				</div>
				<div class="panel-body">
					<label><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_ORDER_BY');?></label>
					<select name="filter_order" size="1">
						<option value="a.created"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_DATE');?></option>
						<option value="a.responses"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES');?></option>
						<option value="a.catid"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CATEGORY');?></option>
					</select>
					<label><?php echo JText::_('COM_COMMUNITYSURVEYS_SEARCH_ORDER');?></label>
					<select name="filter_order_Dir" size="1">
						<option value="asc"><?php echo JText::_('COM_COMMUNITYSURVEYS_ASCENDING');?></option>
						<option value="desc"><?php echo JText::_('COM_COMMUNITYSURVEYS_DESCENDING');?></option>
					</select>
				</div>
			</div>
		</div>
		<div class="span6 col-md-6">
			<div class="panel panel-<?php echo $theme;?>">
				<div class="panel-heading">
					<div class="panel-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CATEGORIES');?></div>
				</div>
				<div class="panel-body">
					<?php 
					$categories = JHtml::_('category.categories', 'com_communitysurveys');
					foreach ($categories as $id=>$category)
					{
						if($category->value == '1') 
						{
							unset($categories[$id]);
						}
					}
					
					$nocat = new JObject();
					$nocat->set('text', JText::_('COM_COMMUNITYSURVEYS_LABEL_ALL_CATEGORIES'));
					$nocat->set('value', '0');
					$nocat->set('disable', false);
					
					array_unshift($categories, $nocat);
					echo JHTML::_('select.genericlist', $categories, 'catid[]', 'size = "6" multiple="multiple"');
					?>
				</div>
			</div>
		</div>
	</div>
	<div class="well">
		<div class="center">
			<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getSurveysRoute())?>" class="btn btn-default"><?php echo JText::_('JCANCEL');?></a>
			<button class="btn btn-primary" type="submit"><i class="fa fa-search-plus"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SEARCH');?></button>
		</div>
	</div>
	
	<input type="hidden" name="view" value="surveys">
	<input type="hidden" id="filter_featured" name="filter_featured" value="">
</form>