<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$user 		= JFactory::getUser();
$data		= $displayData['data'];
$pagination = $data->pagination;
$params		= $data->params;
$layout		= $params->get('ui_layout', 'default');
?>
<p class="contact-groups-intro"><?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE_CONTACT_GROUPS_INTRO');?></p>

<div id="contact-groups-wrapper">
	<ul class="nav nav-tabs" role="tablist">
		<li role="presentation" class="active">
			<a href="#tabContactGroups" aria-controls="home" role="tab" data-toggle="tab"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONTACT_GROUPS');?></a>
		</li>
		<li role="presentation">
			<a href="#tabContacts" aria-controls="profile" role="tab" data-toggle="tab"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONTACTS');?></a>
		</li>
	</ul>
	<div class="tab-content">
		<div role="tabpanel" class="tab-pane active" id="tabContactGroups">
			<div class="contact-groups-listing">
				<?php echo $this->sublayout('groupslist', array('data'=>$data));?>
			</div>	
		</div>
		<div role="tabpanel" class="tab-pane" id="tabContacts">
			<div class="contacts-filter">
				<div class="pull-right margin-left-10">
					<select size="1" name="contacts_limit" style="width: 100%;" 
						onchange="document.inviteForm.limit.value=this.value;CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.getcontacts', 'onBeforeLoadContacts', 'onAfterLoadContacts'); return false;">
						<option value="10"<?php echo $pagination->limit == 10 ? ' selected="selected"' : '';?>>10</option>
						<option value="20"<?php echo $pagination->limit == 20 ? ' selected="selected"' : '';?>>20</option>
						<option value="30"<?php echo $pagination->limit == 30 ? ' selected="selected"' : '';?>>30</option>
						<option value="50"<?php echo $pagination->limit == 50 ? ' selected="selected"' : '';?>>50</option>
						<option value="100"<?php echo $pagination->limit == 100 ? ' selected="selected"' : '';?>>100</option>
					</select>
				</div>
				<div class="pull-right span3">
					<select size="1" name="filter_group_id" style="width: 100%;">
						<option><?php echo JText::_('JGLOBAL_SELECT_AN_OPTION');?></option>
						<?php if(!empty($data->cgroups)):?>
							<?php foreach ($data->cgroups as $group):?>
							<option value="<?php echo $group->id;?>"><?php echo $this->escape($group->name);?></option>
							<?php endforeach;?>
						<?php endif;?>
					</select>
				</div>
				<div class="search-contacts">
					<input type="text" name="filter_search" placeholder="<?php echo JText::_('JSEARCH_FILTER_SUBMIT');?>">
					<button type="button" class="btn btn-primary"
						onclick="CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.getcontacts', 'onBeforeLoadContacts', 'onAfterLoadContacts'); return false;">
						<i class="fa fa-search"></i> <?php echo JText::_('JSEARCH_FILTER_SUBMIT');?>
					</button>
				</div>
			</div>
			<div class="contacts-listing">
				<?php echo $this->sublayout('contactslist', array('data'=>$data));?>
			</div>
		</div>
	</div>
</div>

<div id="cgroup-form-modal" class="cgroup-form-modal modal fade" style="display: none;">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="<?php echo JText::_('JTOOLBAR_CLOSE')?>">
					<span aria-hidden="true">&times;</span>
				</button>
				<h4 class="modal-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ADD_CONTACT_GROUP')?></h4>
			</div>
			<div class="modal-body">
				<div class="form-horizontal">
					<div class="control-group">
						<label for="jform_group_name" class="span3 control-label">
							<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_GROUP_NAME');?>
						</label>
						<div class="span9">
							<input type="text" name="jform[group_name]" id="jform_group_name" value="" class="form-control">
						</div>
					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo JText::_('JTOOLBAR_CLOSE')?></button>
				<button type="button" class="btn btn-primary"
					onclick="CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.savegroup', 'onBeforeSaveContactGroup', 'onAfterSaveContactGroup'); return false;">
					<?php echo JText::_('JTOOLBAR_SAVE')?>
				</button>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="contacts-form-modal" class="contacts-form-modal modal fade" style="display: none;">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="<?php echo JText::_('JTOOLBAR_CLOSE')?>">
					<span aria-hidden="true">&times;</span>
				</button>
				<h4 class="modal-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ADD_CONTACTS')?></h4>
			</div>
			<div class="modal-body" style="overflow: scroll; overflow-x: none;">
				<table class="table table-condensed">
					<thead>
						<tr>
							<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_CONTACT_NAME')?></th>
							<th><?php echo JText::_('JGLOBAL_EMAIL')?></th>
						</tr>
					</thead>
					<tbody>
						<?php for ($i = 0; $i < 10; $i++):?>
						<tr>
							<td><input type="text" name="jform[contact_name][]"></td>
							<td><input type="text" name="jform[contact_email][]"></td>
						</tr>
						<?php endfor;?>
					</tbody>
				</table>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo JText::_('JTOOLBAR_CLOSE')?></button>
				<button type="button" class="btn btn-primary"
					onclick="CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.savecontacts', 'onBeforeSaveContacts', 'onAfterSaveContacts'); return false;">
					<?php echo JText::_('JTOOLBAR_SAVE')?>
				</button>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="contacts-import-modal" class="contacts-import-modal modal fade" style="display: none;">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="<?php echo JText::_('JTOOLBAR_CLOSE')?>">
					<span aria-hidden="true">&times;</span>
				</button>
				<h4 class="modal-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_IMPORT_CONTACTS')?></h4>
			</div>
			<div class="modal-body">
				<div><?php echo JText::_('COM_COMMUNITYSURVEYS_IMPORT_CONTACTS_INTRO');?></div>
				<button type="button" class="btn btn-primary btn-select-csv-file">
					<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SELECT_FILE');?>
				</button>
				<span class="csv_filename_label"></span>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo JText::_('JTOOLBAR_CLOSE')?></button>
				<button type="button" class="btn btn-primary"
					onclick="CjSurveyApi.submitAjaxForm(this, '#import_contacts_form', 'invite.importcontacts', 'onBeforeImportContacts', 'onAfterImportContacts'); return false;">
					<?php echo JText::_('JTOOLBAR_SAVE')?>
				</button>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<div id="assign-contacts-modal" class="assign-contacts-modal modal fade" style="display: none;">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-label="<?php echo JText::_('JTOOLBAR_CLOSE')?>">
					<span aria-hidden="true">&times;</span>
				</button>
				<h4 class="modal-title"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ASSIGN_CONTACTS')?></h4>
			</div>
			<div class="modal-body">
				<div><?php echo JText::_('COM_COMMUNITYSURVEYS_ASSIGN_CONTACTS_INTRO');?></div>
				<div class="assign-contacts-wraper"></div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo JText::_('JTOOLBAR_CLOSE')?></button>
				<button type="button" class="btn btn-primary"
					onclick="CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.assigncontacts', 'onBeforeAssignContacts', 'onAfterAssignContacts'); return false;">
					<?php echo JText::_('JTOOLBAR_SAVE')?>
				</button>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->