<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

$app        = JFactory::getApplication();
$user 		= JFactory::getUser();
$data		= $displayData['data'];

$survey		= $data->item;
$params 	= $data->params;
$state		= $data->state;
$pagination	= $data->pagination;
$responses	= $data->responses;

$userId		= $user->get('id');
$archived	= $state->get('filter.published') == 2 ? true : false;
$trashed	= $state->get('filter.published') == -2 ? true : false;
$listOrder	= $this->escape($state->get('list.ordering'));
$listDirn	= $this->escape($state->get('list.direction'));
$profileApp = $params->get('profile_component', 'none');
$uri        = CommunitySurveysHelperRoute::getReportsRoute($survey->id, $survey->language);
$api        = new CjLibApi();
?>
<script type="text/javascript">
	Joomla.orderTable = function()
	{
		table = document.getElementById("sortTable");
		direction = document.getElementById("directionTable");
		order = table.options[table.selectedIndex].value;
		if (order != '<?php echo $listOrder; ?>')
		{
			dirn = 'asc';
		}
		else
		{
			dirn = direction.options[direction.selectedIndex].value;
		}
		Joomla.tableOrdering(order, dirn, '');
	}
</script>

<?php echo $this->sublayout('filter', array('data' => $data));?>

<div class="table-responsive">
	<table class="table table-striped" id="responsesList">
		<thead>
			<tr>
				<th width="1%" class="hidden-phone">
					<?php echo JHtml::_('grid.checkall'); ?>
				</th>
				<th width="1%" style="min-width:55px" class="nowrap text-center">
					<?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
				</th>
				<?php if($app->isAdmin()):?>
				<th>
					<?php echo JHtml::_('searchtools.sort', 'JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder); ?>
				</th>
				<?php endif;?>
				<th class="text-center">
					<?php echo JHtml::_('searchtools.sort',  'JAUTHOR', 'a.created_by', $listDirn, $listOrder); ?>
				</th>
				<th width="10%" class="hidden-phone">
					<?php echo JHtml::_('searchtools.sort', 'JDATE', 'a.created', $listDirn, $listOrder); ?>
				</th>
				<th width="3%" class="hidden-phone center text-center">
					<?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.completed', $listDirn, $listOrder); ?>
				</th>
				<th width="10%" class="hidden-phone">
					<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_COUNTRY', 't.country', $listDirn, $listOrder); ?>
				</th>
				<th width="10%" class="hidden-phone">
					<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_CITY', 't.city', $listDirn, $listOrder); ?>
				</th>
				<?php if($app->isAdmin()):?>
				<?php if($user->authorise('core.admin', 'com_communitysurveys')):?>
				<th width="5%" class="nowrap hidden-phone">
					<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_IP_ADDRESS', 't.ip_address', $listDirn, $listOrder); ?>
				</th>
				<?php endif;?>
				<th width="10%" class="hidden-phone">
					<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_BROWSER', 't.browser_name', $listDirn, $listOrder); ?>
				</th>
				<th width="10%" class="hidden-phone">
					<?php echo JHtml::_('searchtools.sort', 'COM_COMMUNITYSURVEYS_OS', 't.os', $listDirn, $listOrder); ?>
				</th>
				<?php endif;?>
				<th width="1%" class="nowrap">
					<?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
				</th>
			</tr>
		</thead>
		<tbody>
		<?php
		 if(!empty($responses))
		 {
			$canChangeState	= $user->authorise('core.edit.state', 'com_communitysurveys.survey.'.$survey->id);
			$canViewResults = $user->authorise('core.results',	  'com_communitysurveys.survey.'.$survey->id);
			
		    foreach ($responses as $i => $item)
			{
				$canCheckin 	= $user->authorise('core.manage',     'com_checkin') || $item->checked_out == $userId || $item->checked_out == 0;
				$canChange  	= $canChangeState && $canCheckin;
				?>
				<tr class="row<?php echo $i % 2; ?>">
					<td class="center hidden-phone">
						<?php echo JHtml::_('grid.id', $i, $item->id); ?>
					</td>
					<td class="center">
						<div class="btn-group">
							<?php echo JHtml::_('jgrid.published', $item->state, $i, 'responses.', $canChange, 'cb'); ?>
							<?php
							// Create dropdown items
							$action = $archived ? 'unarchive' : 'archive';
							JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'responses');
		
							$action = $trashed ? 'untrash' : 'trash';
							JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'responses');
							
							JHtmlActionsDropdown::addCustomItem(JText::_('COM_COMMUNITYSURVEYS_LABEL_REOPEN_RESPONSE'), 'play-circle', 'cb' . $i, 'responses.reopen');
							
							// Render dropdown list
							echo JHtml::_('actionsdropdown.render', $this->escape($item->title));
							?>
						</div>
					</td>
					<?php if($app->isAdmin()):?>
					<td class="has-context">
						<div class="pull-left comments-wrap">
							<?php if ($item->language == '*'):?>
								<?php $language = JText::alt('JALL', 'language'); ?>
							<?php else:?>
								<?php $language = !empty($item->language_title) ? $this->escape($item->language_title) : JText::_('JUNDEFINED'); ?>
							<?php endif;?>
							
							<?php if ($canViewResults) : ?>
								<a href="<?php echo JRoute::_($uri.'&layout=response&rid='.$item->id); ?>" 
									title="<?php echo JText::_('JACTION_EDIT'); ?>">
									<?php echo $this->escape($item->title); ?>
								</a>
								<small class="text-muted">
									<a href="#" onclick="return false;" class="btn-add-comment text-error" data-rid="<?php echo $item->id;?>">
										(<?php echo empty($item->comment) ? JText::_('COM_COMMUNITYSURVEYS_ADD_COMMENT') : JText::_('COM_COMMUNITYSURVEYS_EDIT_COMMENT');?>)
									</a>
								</small>
								<div class="comment"><?php echo $item->comment;?></div>
							<?php else : ?>
								<span title="<?php echo JText::sprintf('JFIELD_ALIAS_LABEL', $this->escape($item->alias)); ?>"><?php echo $this->escape($item->title); ?></span>
							<?php endif; ?>
						</div>
					</td>				
					<?php endif;?>
					<td>
						<?php 
						if($canCheckin && $app->isAdmin() && $item->created_by > 0)
						{
                            ?>
                            <a href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id='.(int) $item->created_by); ?>" title="<?php echo JText::_('JAUTHOR'); ?>">
                                <?php echo $this->escape($item->author_name); ?>
                            </a>
                            <?php 
						}
						else
						{
							echo $item->created_by > 0 ? JHtml::link($api->getUserProfileUrl($profileApp, $item->created_by), $this->escape($item->author_name)) : JText::_('COM_COMMUNITYSURVEYS_GUEST');
						}
                        ?>
					</td>
					<td class="nowrap small">
						<?php echo JHtml::_('date', $item->created, JText::_('DATE_FORMAT_LC2')); ?>
					</td>
					<td class="text-center center">
						<?php if(strlen($item->completed) > 0 && $item->completed != '0000-00-00 00:00:00'): ?>
						<span data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_RESPONSE_FINALIZED')?>">
							<i class="fa fa-check-square"></i>
						</span>
						<?php else :?>
						<span data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_RESPONSE_PENDING')?>">
							<i class="fa fa-square-o"></i>
						</span>
						<?php endif;?>
					</td>
					<td class="hidden-phone">
						<?php echo $item->country_name;?>
					</td>
					<td class="hidden-phone">
						<?php echo $item->city;?>
					</td>
					<?php if($app->isAdmin()):?>
					<td class="hidden-phone">
						<?php echo $item->ip_address;?>
					</td>
					<td class="hidden-phone">
						<?php echo $item->browser_name;?>
					</td>
					<td class="hidden-phone">
						<?php echo $item->os;?>
					</td>
					<?php endif;?>
					<td class="center">
						<?php 
						if($user->id == $survey->created_by || $canViewResults)
						{
							?>
							<a href="<?php echo JRoute::_($uri.'&layout=response&rid='.$item->id);?>">
                                <?php echo (int) $item->id;?>
                            </a>
							<?php
						} 
						else
						{
							echo (int) $item->id;
						}
						?>
					</td>
				</tr>
				<?php
			}
		} 
		else 
		{
			?>
			<tr>
				<td colspan="<?php echo $app->isAdmin() ? '12' : '9';?>"><i class="fa fa-info-cirlce"></i> <?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS')?></td>
			</tr>
			<?php
		}
		?>
		</tbody>
		<tfoot>
			<tr>
				<td colspan="<?php echo $app->isAdmin() ? '12' : '9';?>"><?php echo $pagination->getListFooter(); ?></td>
			</tr>
		</tfoot>
	</table>
</div>
