<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$free_text 			= '';
$required			= $item->mandatory ? ' required' : '';
$customAnswerPH     = $item->params->get('custom_answer_placeholder', JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER'));
?>
<ul class="list-group no-margin-left" role="group" aria-label="<?php echo $this->escape(strip_tags($item->title));?>">
	<?php 
	if($item->orientation == 'IL') 
	{
		?>
		<li class="list-group-item">
			<ul class="list-unstyled unstyled inline list-inline">
		<?php
	}
	
	$range_selection = '';
	if( $item->min_selections > 0 && $item->max_selections > 0 && $item->max_selections >= $item->min_selections )
	{
		$range_selection = ' minselect="'.$item->min_selections.'" maxselect="'.$item->max_selections.'" data-field-type="checkbox"';
	}
	else if( $item->min_selections > 0 )
	{
		$range_selection = ' minselect="'.$item->min_selections.'" data-field-type="checkbox"';
	}
	else if( $item->max_selections > 0 )
	{
		$range_selection = ' minselect=0 maxselect="'.$item->max_selections.'" data-field-type="checkbox"';
	}
	
	foreach ($item->answers as $answer)
	{
		$checked = false;
		$rules = '';
		foreach ($item->responses as $response)
		{
			if($answer->id == $response->answer_id)
			{
				$checked = true;
			} 
			else if(!empty($response->free_text))
			{
				$free_text = $this->escape($response->free_text);
			}
		}
		
		if(isset($item->rule_selected[$answer->id]))
		{
			$rules = ' showitems="'.implode(',', $item->rule_selected[$answer->id]).'"';
		}
		?>
		<li<?php echo $item->orientation != 'IL' ? ' class="list-group-item"' : '';?>>
			<div class="form-check">
				<label class="form-check-label" for="answer-<?php echo $answer->id;?>">
					<input type="checkbox" 
						name="answer-<?php echo $item->id;?>[]" 
						id="answer-<?php echo $answer->id;?>"
						value="<?php echo $answer->id?>"<?php echo $checked ? ' checked="checked"' : '';?> 
						class="form-check-input<?php echo $required;?> mgc mgc-primary"<?php echo $range_selection . $rules;?>
						role="checkbox" 
						aria-checked="<?php echo $checked ? 'true' : 'false';?>" 
						aria-describedby="<?php echo $this->escape(strip_tags($answer->title));?>"
						tabindex="0"> <?php echo $this->escape($answer->title);?>
				</label>
			</div>
		</li>
		<?php
	}
	
	if($item->orientation == 'IL')
	{
		?>
			</ul>
		</li>
		<?php
	}

	if($item->custom_choice == 1)
	{
		?>
		<li class="list-group-item">
			<input type="text" name="free-text-<?php echo $item->id;?>" class="input-xlarge valid" 
				value="<?php echo $free_text;?>" placeholder="<?php echo $customAnswerPH;?>" aria-required="false" aria-label="<?php echo $customAnswerPH;?>">
		</li>
		<?php
	}
	?>
</ul>