<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$num_ratings		= $item->params->get('num_rating_stars', 5);
$free_text			= '';
$customAnswerPH     = $item->params->get('custom_answer_placeholder', JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER'));
$hints              = explode(',', $this->escape($item->params->get('rating_hints', JText::_('COM_COMMUNITYSURVEYS_RATING_HINTS_TEXT'))));
$hints              = array_pad($hints, $num_ratings, '');
?>
<table class="table table-striped table-hover">
	<?php 
	foreach ($item->answers as $answer)
	{
		$rating = 0;
		$rules = '';
		
		foreach ($item->responses as $response)
		{
			if($answer->id == $response->answer_id)
			{
				$rating = $response->column_id;
				$free_text = CjLibUtils::escape($response->free_text);
			} 
		}
		
		if(isset($item->rule_selected[$answer->id]))
		{
			$ruleItems = array();
			foreach ($item->rule_selected[$answer->id] as $ratingNum => $showQnId)
			{
				$ruleItems[] = $ratingNum . '_' . $showQnId[0];
			}

			$rules = ' showitems="' . implode(',', $ruleItems) . '"';
		}
		?>
		<tr>
			<td class="title" width="80%">
				<?php echo $this->escape($answer->title);?>
			</td>
			<td nowrap="nowrap" class="rating-wrapper">
				<select size="1" id="answer-<?php echo $item->id.'-'.$answer->id;?>" name="answer-<?php echo $item->id.'-'.$answer->id;?>" <?php echo $item->mandatory ? 'required="required"' : '';?>
					data-toggle="rating" data-score="<?php echo (float) $rating;?>" data-theme="fontawesome-stars-o" <?php echo $rules;?> class="chosen-disabled">
					<option value=""></option>
					<?php 
					for($i = 1; $i <= $num_ratings; $i++)
					{
					    $rules = '';
					    if(isset($item->rule_selected[$answer->id]))
					    {
					        $ruleItems = array();
					        foreach ($item->rule_selected[$answer->id] as $ratingNum => $showQnId)
					        {
					            if($ratingNum == $i) 
					            {
					                $ruleItems[] = $showQnId[0];
					            }
					        }
					        
					        $rules = ' showitems="' . implode(',', $ruleItems) . '"';
					    }
					    ?>
						<option value="<?php echo $i;?>" data-html="<?php echo trim($hints[$i - 1]);?>" <?php echo $i == $rating ? 'selected="selected"' : '';?><?php echo $rules;?>><?php echo $i;?></option>
						<?php 
					}
					?>
				</select>
				
				<span class="text-muted small selected-rating-text"></span>
				<a href="#" class="text-muted small cancel-selected-rating" onclick="return false;" style="display: none;"><i class="fa fa-times-circle"></i></a>
			</td>
			<?php if($item->custom_choice == 1):?>
			<td>
				<input type="text" name="custom-text-<?php echo $answer->id;?>" class="valid" style="margin-bottom: 0;"
					value="<?php echo $free_text;?>" placeholder="<?php echo $customAnswerPH;?>" aria-required="false" aria-label="<?php echo $customAnswerPH;?>">
			</td>
			<?php endif;?>
		</tr>
		<?php
	}
	?>
</table>