<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$required			= $item->mandatory ? ' required' : '';
$regex 				= new stdClass();
$regex->regex 		= $this->escape($item->params->get('regex', ''));
$regex->message 	= $this->escape($item->params->get('regex_msg', ''));
$regExHtml			= !empty($regex->regex) ? ' data-regex="'.CjLibUtils::escape(json_encode($regex, JSON_HEX_QUOT|JSON_HEX_TAG|JSON_HEX_AMP|JSON_HEX_APOS)).'"' : '';
?>
<ul class="list-group no-margin-left">
	<li class="list-group-item">
		<?php 
		foreach ($item->responses as $response)
		{
			if(!empty($response->free_text))
			{
				$free_text = $this->escape($response->free_text);
				break;
			}
		}
		?>
		<input type="password" name="free-text-<?php echo $item->id;?>" class="input-xlarge<?php echo $required;?>" 
			value="" placeholder="<?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_YOUR_ANSWER');?>" <?php echo $regExHtml;?>
			aria-label="<?php echo $this->escape(strip_tags($item->title));?>">
	</li>
</ul>