<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$items      = $displayData['items'];
$params     = $displayData['params'];
$theme      = $params->get('theme', 'default');
?>

<table class="table table-hover table-striped table-bordered">
	<thead>
		<tr>
			<th><?php echo JText::_('JGLOBAL_TITLE');?></th>
			<th width="25%"><?php echo JText::_('JDATE');?></th>
			<th width="25%"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_COMPLETED');?></th>
		</tr>
	</thead>
	<tbody>
		<?php if(count($items)):?>
			<?php foreach ($items as $i=>$item):?>
			<tr>
				<td>
					<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getResponseRoute($item->survey_id, $item->id));?>">
						<?php echo $this->escape($item->title);?>
					</a>
				</td>
				<td><?php echo JHtml::_('date', $item->created, JText::_('DATE_FORMAT_LC2')); ?></td>
				<td><?php echo JHtml::_('date', $item->completed, JText::_('DATE_FORMAT_LC2')); ?></td>
			</tr>
			<?php endforeach;?>
		<?php else :?>
		<tr>
			<td colspan="8">
				<div class="alert alert-info"><?php echo JText::_('JGLOBAL_SELECT_NO_RESULTS_MATCH');?></div>
			</td>
		</tr>
		<?php endif;?>
	</tbody>
</table>