<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];
$theme 				= $params->get('theme', 'default');
$free_text 			= '';
$required			= $item->mandatory ? ' required' : '';
$correct_answer 	= true;
$icon 				= $item->question_type == CS_IMAGE_CHOOSE_IMAGES ? 'fa fa-square-o' : 'fa fa-circle-o';
?>
<ul class="list-group no-margin-left">
	<li class="list-group-item">		
		<?php
		foreach ($item->answers as $i=>$answer)
		{
			$selected = false;
			foreach ($item->responses as $response)
			{
				if($response->answer_id == $answer->id)
				{
					$selected = true;
				} 
				else if(!empty($response->free_text))
				{
					$free_text = $response->free_text;
				}
			}
			
			if($i % 6 == 0) 
			{
				?>
				<div class="row-fluid">
				<?php
			}
			?>
			<div class="span2">
				<div class="thumbnail text-center">
					<img src="<?php echo CS_IMAGES_URI.$answer->image;?>" alt="<?php echo $this->escape($answer->title);?>">
					<div class="form-inline margin-top-10">
						<?php
						if($selected)
						{
							?>
							<i class="fa fa-check-square-o" data-toggle="tooltip" title="<?php echo JText::_('COM_COMMUNITYSURVEYS_RESULT_YOUR_ANSWER');?>"></i>
							<?php 
						}
						else
						{
							?>
							<i class="<?php echo $icon;?> text-muted"></i>
							<?php
						}
						?>
                        <span><?php echo $this->escape($answer->title);?></span>
					</div>
				</div>
			</div>
			<?php 
			if($i % 6 == 5 || count($item->answers) == ($i + 1)) 
			{
				?>
				</div>
				<?php 
			}
		}
		?>
	</li>
	<li class="list-group-item choice-answer"><?php echo $this->escape($free_text);?></li>
</ul>