<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$item 				= $displayData['item'];
$num_ratings		= $item->params->get('num_rating_stars', 5);
?>
<table class="table table-striped table-hover">
	<?php
	foreach($item->answers as $answer)
	{
		$rating = 0;
		$free_text = '';
		if(!empty($item->responses))
		{
			foreach ($item->responses as $response)
			{
				if($answer->id == $response->answer_id)
				{
					$rating = $response->column_id;
					$free_text = $response->free_text;
					break;
				}
			}
		}
		?>
		<tr class="star-rating">
			<td class="title" width="60%">
				<?php echo $this->escape($answer->title);?>
			</td>
			<td nowrap="nowrap">
				<select size="1" data-toggle="rating" data-score="<?php echo (float) $rating;?>" data-theme="fontawesome-stars-o" class="chosen-disabled">
					<?php for($i = 1; $i <= $num_ratings; $i++): ?>
					<option value="<?php echo $i;?>"><?php echo $i;?></option>
					<?php endfor;?>
				</select>
			</td>
			<td>
				<?php echo CjLibUtils::escape($free_text);?>
			</td>
		</tr>
		<?php
	}
	?>
</table>