<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];
$theme 				= $params->get('theme', 'default');
$free_text 			= '';
$required			= $item->mandatory ? ' required' : '';
?>
<ul class="list-group no-margin-left">
	<li class="list-group-item">
		<?php
		if(!empty($item->responses))
		{
			foreach ($item->responses as $response)
			{
				if(!empty($response->answer_id))
				{
					?>
					<p><strong><?php echo JText::_('COM_COMMUNITYSURVEYS_RESULT_YOUR_ANSWER');?>:</strong> <?php echo $this->escape($response->answer_id);?></p>
					<?php
				}
				else if(!empty($response->free_text))
				{
					?>
					<p><strong><?php echo JText::_('COM_COMMUNITYSURVEYS_RESULT_YOUR_ANSWER');?>:</strong></p>
					<div><?php echo $this->escape($response->free_text);?></div>
					<?php
				}
			}
		}
		else 
		{
			echo JText::_('COM_COMMUNITYSURVEYS_NO_ANSWER_PROVIDED');
		}
		?>
	</li>
</ul>