<?php
/**
 * @package     corejoomla.site
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$user = JFactory::getUser();

$params = $displayData['params'];
$state = $displayData['state'];

$category = isset($displayData['category']) ? $displayData['category'] : null;
$asset = !empty($category) ? 'com_communitysurveys.category.'.$category->id : 'com_communitysurveys';

if($params->get('show_toolbar', 1) == 1)
{
	$allowCreate 	= $user->authorise('core.create', $asset) || count($user->getAuthorisedCategories('com_communitysurveys', 'core.create'));
	$allowRespond	= $user->authorise('core.respond', $asset) || count($user->getAuthorisedCategories('com_communitysurveys', 'core.respond'));
	?>
	<nav class="navbar navbar-default" role="navigation">
		<div class="navbar-inner">
			<div class="navbar-header">
				<button type="button" class="btn btn-navbar navbar-toggle" data-toggle="collapse" data-target="#cs-navbar-collapse" aria-controls="navbar">
	<!-- 				<span class="sr-only">Toggle navigation</span> -->
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
				</button>
				<a class="brand" href="<?php echo JRoute::_('index.php?option=com_communitysurveys');?>">
					<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_HOME');?>
				</a>
			</div>
			<div class="collapse nav-collapse navbar-collapse navbar-responsive-collapse" id="cs-navbar-collapse">
				<?php if(!$user->guest && ($allowCreate || $allowRespond)):?>
				<ul class="nav pull-right no-margin-bottom">
				
					<?php if($allowCreate):?>
	                <li>
	                    <a href="<?php echo CommunitySurveysHelperRoute::getFormRoute();?>"><?php echo JText::_('COM_COMMUNITYSURVEYS_CREATE_SURVEY');?></a>
	                </li>
	                <?php endif;?>
	                
					<li class="dropdown">
						<a href="#" class="dropdown-toggle" data-toggle="dropdown"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ACCOUNT');?> <b class="caret"></b></a>
						<ul class="dropdown-menu">
							<li class="nav-header"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_MY_STUFF');?></li>
							
							<?php if($allowCreate):?>
							<li>
								<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getMySurveysRoute());?>">
									<i class="fa fa-user"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_MY_SURVEYS');?>
								</a>
							</li>
							<?php endif;?>
							
							<?php if($allowRespond):?>
							<li>
								<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getMyResponsesRoute());?>">
									<i class="fa fa-file-o"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_MY_RESPONSES');?>
								</a>
							</li>
							<?php endif?>
						</ul>
					</li>
				</ul>
				<?php endif;?>
				<ul class="nav no-margin-bottom">
					<li class="dropdown">
						<a href="#" class="dropdown-toggle" data-toggle="dropdown">
							<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_DISCOVER');?> <b class="caret"></b>
						</a>
						<ul class="dropdown-menu">
							<li class="nav-header"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SURVEYS');?></li>
							<li<?php echo (is_object($state) && $state->get('list.ordering') == 'a.created') ? ' class="active"' : '';?>>
								<a href="<?php echo CommunitySurveysHelperRoute::getSurveysRoute().'&recent=true';?>">
									<i class="fa fa-tasks"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RECENT_SURVEYS')?>
								</a>
							</li>
							<li<?php echo (is_object($state) && $state->get('list.ordering') == 'a.responses') ? ' class="active"' : '';?>>
								<a href="#" onclick="filterSurveys('', 'a.responses', 'desc', 0); return false;">
									<i class="fa fa-fire"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_POPULAR_SURVEYS')?>
								</a>
							</li>
							<li class="divider"></li>
							<li class="nav-header"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SEARCH');?></li>
							<li>
								<a href="<?php echo CommunitySurveysHelperRoute::getSearchRoute();?>">
									<i class="fa fa-users"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ADVANCED_SEARCH')?>
								</a>
							</li>
						</ul>
					</li>
				</ul>
			</div>
		</div>
	</nav>
	<?php 
}
?>

<form id="toolbarAuthorForm" name="toolbarAuthorForm" action="<?php echo JRoute::_('index.php');?>" method="post" style="display: none;">
	<input type="hidden" id="filter_author_id" name="filter_author_id" value="<?php echo $user->id;?>">
	<input type="hidden" id="view" name="view" value="surveys">
</form>

<form id="toolbarFilterForm" name="toolbarFilterForm" action="<?php echo JRoute::_('index.php?option=com_communitysurveys&view=surveys');?>" method="post" style="display: none;">
	<input type="hidden" id="filter_featured" name="filter_featured" value="">
	<input type="hidden" id="filter_order" name="filter_order" value="created">
	<input type="hidden" id="filter_order_Dir" name="filter_order_Dir" value="desc">
	<input type="hidden" id="filter_unanswered" name="filter_unanswered" value="0">
	<input type="hidden" id="view" name="view" value="surveys">
</form>

<script type="text/javascript">
<!--
function filterSurveys(featured, order, direction, unanswered)
{
	document.toolbarFilterForm.filter_featured.value = featured;
	document.toolbarFilterForm.filter_order.value = order;
	document.toolbarFilterForm.filter_order_Dir.value = direction;
	document.toolbarFilterForm.filter_unanswered.value = unanswered;

	document.toolbarFilterForm.submit();
}
//-->
</script>