<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];
$theme 				= $params->get('theme', 'default');
$stats				= array();

foreach ($item->answers as &$answer)
{
	$answer->votes = 0;
	$answer->value = 0;
	foreach ($item->responses as $response)
	{
		if($answer->id == $response->answer_id)
		{
			$answer->votes = $answer->votes + $response->votes;
			$answer->value = $answer->value + ($response->column_id * $response->votes);
		}
	}
}
reset($item->answers);
unset($answer);
$max_rating = $item->params->get('num_rating_stars', 5);
?>
<table style="border:1px solid grey; border-collapse:collapse;">
	<thead>
		<tr>
			<th style="border:1px solid grey; padding: 5px;"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_QUESTIONS')?></th>
			<th style="border:1px solid grey; text-align: center; padding: 5px;"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RATING')?></th>
			<th style="border:1px solid grey; text-align: center; padding: 5px;"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES')?></th>
		</tr>
	</thead>
	<tbody>
		<?php 
		foreach ($item->answers as $answer)
		{
			$score = ($answer->votes > 0 && $max_rating > 0) ? (float) round($max_rating * $answer->value / ($answer->votes * $max_rating), 2) : 0;
			?>
			<tr>
				<td style="border:1px solid grey; padding: 5px;"><?php echo $this->escape($answer->title);?></td>
				<td style="border:1px solid grey; text-align: center; padding: 5px;"><?php echo $score;?></td>
				<td style="border:1px solid grey; text-align: center; padding: 5px;"><?php echo $answer->votes;?></td>
			</tr>
			<?php 
		}
		?>
	</tbody>
</table>