<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];
$theme 				= $params->get('theme', 'default');
$stats				= array();

$promoterScore		= 0;
$detractorScore		= 0;
$item->votes		= 0;
$scores				= array();
$colors 			= array('#DC3912', '#DC3912', '#DC3912', '#DC3912', '#DC3912', '#DC3912', '#FF9900', '#FF9900', '#109618', '#109618');

for ($i = 1; $i <= 10; $i++)
{
	$score = 0;
	foreach ($item->responses as $response)
	{
		if($i == $response->answer_id)
		{
			$score = $response->votes;
			$item->votes += $response->votes;
			
			if($i < 7)
			{
				$detractorScore = $detractorScore + $response->votes;
			}
			
			if($i > 8)
			{
				$promoterScore = $promoterScore + $response->votes;
			}
			
			break;
		}
	}
	
	$scores[] = $score;
}
reset($item->answers);
$promoterPct 	= $item->votes > 0 ? round($promoterScore / $item->votes * 100) : 0;
$detractorPct 	= $item->votes > 0 ? round($detractorScore / $item->votes * 100) : 0;
$nps 			= $promoterPct - $detractorPct;
?>
<div class="panel-body nps-container">
	<?php
	for ($i = 1; $i <= 10; $i++)
	{
		$pct = $item->votes > 0 ? round( $scores[$i -1] * 100 / $item->votes, 2) : 0;
		$color = $colors[$i - 1]
		?>
		<label><?php echo $i . ' <small>(' . $pct . '% / ' . JText::plural('COM_COMMUNITYSURVEYS_LABEL_VOTES', $scores[$i - 1]) . ')</small>';?></label>
		<br/>
		<table>
			<tr>
				<td align="right" width="<?php echo $pct > 0 ? $pct.'%' : 1;?>" bgcolor="<?php echo $color;?>">
					<?php echo $pct > 0 ? $pct .'%' : '';?>
				</td>
			</tr>
		</table>
		<br><br/>
		<?php
	}
	?>
	
	<h4><?php echo JText::sprintf('COM_COMMUNITYSURVEYS_NPS_VALUE', $nps);?></h4>
	<span class="label label-success"><?php echo $promoterPct;?>%</span>&nbsp;<?php echo JText::_('COM_COMMUNITYSURVEYS_PROMOTERS')?>&nbsp;-&nbsp;
	<span class="label label-important"><?php echo $detractorPct;?>%</span>&nbsp;<?php echo JText::_('COM_COMMUNITYSURVEYS_DETRACTORS')?>
</div>