<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];
$theme 				= $params->get('theme', 'default');
$icon 				= $item->question_type == CS_CHOICE_CHECKBOX ? 'fa fa-square-o' : 'fa fa-circle-o';
$stats				= array();

if(count($item->answers))
{
	$stats[] = '[\''.JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWER').'\',\''.JText::_('COM_COMMUNITYSURVEYS_LABEL_RESPONSES').'\']';
	$item->votes = 0;
	
	foreach ($item->answers as &$answer)
	{
		$answer->votes = 0;
		foreach ($item->responses as $response)
		{
			if($answer->id == $response->answer_id)
			{
				$answer->votes = $answer->votes + $response->votes;
				$item->votes = $item->votes + $response->votes;
			}
		}
		$stats[] = '["'.$this->escape($answer->title).'",'.$answer->votes.']';
	}
	reset($item->answers);
	//$colors = array('51,102,204', '220,57,18', '255,153,0', '16,150,24', '0,153,198', '221,68,119', '102,170,0', '170,170,17', '153,68,153', '230,115,0');
	$colors = array('#3366CC', '#DC3912', '#FF9900', '#109618', '#0099C6', '#DD4477', '#66AA00', '#AAAA11', '#994499', '#E67300');
	?>
	
	<div style="margin-top: 10px;">
		<?php
		foreach ($item->answers as $i=>&$answer)
		{
			$pct = $item->votes > 0 ? round( $answer->votes * 100 / $item->votes, 2) : 0;
			$color = $colors[$i % count($colors)]
			?>
			<label><?php echo $this->escape($answer->title) . ' <small>(' . $pct . '% / ' . JText::plural('COM_COMMUNITYSURVEYS_LABEL_VOTES', $answer->votes) . ')</small>';?></label>
			<br/>
			<table>
				<tr>
					<td align="right" width="<?php echo $pct > 0 ? $pct.'%' : 1;?>" bgcolor="<?php echo $color;?>">
						<?php echo $pct > 0 ? $pct .'%' : '';?>
					</td>
				</tr>
			</table>
			<br><br/>
			<?php
		}
		?>
	</div>
	<?php 
} 
else if(!empty($item->textResponses))
{
	?>
	<table class="table table-striped table-hover">
		<thead>
			<tr>
				<th width="25%"><?php echo JText::_('JGLOBAL_USERNAME');?></th>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWER');?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			foreach ($item->textResponses as $response)
			{
				?>
				<tr>
					<td><?php echo !empty($response->author) ? $this->escape($response->author) : JText::_('COM_COMMUNITYSURVEYS_GUEST');?></td>
					<td><?php echo $this->escape($response->free_text);?></td>
				</tr>
				<?php
			}
			?>
		</tbody>
	</table>
	<?php
}
else
{
	echo '<div class="panel-body">'.JText::_('COM_COMMUNITYSURVEYS_NO_ANSWER_PROVIDED').'</div>';
}