<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];
$free_text 			= '';
$num_ratings		= $item->params->get('num_rating_stars', 5);
?>
<div class="pdf-question">
	<table border="1" cellpadding="2" cellspacing="0">
		<thead>
			<tr>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_QUESTION')?></th>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWER')?></th>
			</tr>
		</thead>
		<tbody>
			<?php 
			foreach ($item->answers as $answer)
			{
				$rating = 0;
				foreach ($item->responses as $response)
				{
					if($answer->id == $response->answer_id)
					{
						$rating = $response->column_id;
					} 
					else if(!empty($response->free_text))
					{
						$free_text = CjLibUtils::escape($response->free_text);
					}
				}
				?>
				<tr>
					<td><?php echo $this->escape($answer->title);?></td>
					<td>
						<table border="0" cellpadding="2" cellspacing="0" width="<?php echo $num_ratings * 20;?>px">
							<tr>
								<?php 
								for ($i = 1; $i <= $num_ratings; $i++)
								{
									?>
									<td>
										<?php if($rating >= $i):?>
										<img src="<?php echo JUri::root(false).'media/com_communitysurveys/images/star1.png'?>" >
										<?php else:?>
										<img src="<?php echo JUri::root(false).'media/com_communitysurveys/images/star3.png'?>" >
										<?php endif;?>
									</td>
									<?php
								}
								?>
							</tr>
						</table>
					</td>
				</tr>
				<?php
			}
			?>
		</tbody>
	</table>
</div>