var CjSurveyApi = {form_submitted: false};
(function($)
{
	CjSurveyApi.initSurveyList = function ()
	{
		// override for custom actions
	};
	
	CjSurveyApi.initTranslations = function() 
	{
		$('#cj-wrapper').on('click', '.editable', function(){
			switch($(this).data('type'))
			{
			case 'text':
				$(this).hide();
				$(this).parent().append($('#tpl-editable-text').html());
				break;
				
			case 'textarea':
				$(this).hide();
				$(this).parent().append($('#tpl-editable-textarea').html());
				break;
			}
			
			var html = $(this).hasClass('editable-empty') ? '' : $.trim($(this).html());
			$(this).parent().find('.editable-input').val(html).focus();
		});
		
		$('#cj-wrapper').on('click', '.editable-parent .btn-cancel', function() {
			$(this).closest('.editable-parent').find('.editable').show();
			$(this).closest('.editable-form').remove();
		});
		
		$('#cj-wrapper').on('click', '.editable-parent .btn-save', function() {
			var btn = $(this);
			var url = $('#url-save-translation').text();
			var id = $(this).closest('.editable-parent').data('id');
			var translation = $(this).closest('.editable-parent').find('.editable-input').val();
			
			btn.prop('disabled', true).find('i').attr('class', 'fa fa-spinner fa-pulse');

			$.ajax({
	            type		: 'POST',
	            url			: url + (/\?/.test(url) ? '&' : '?') +'format=json',
	            data		: {'id': id, 'translation': translation},
	            dataType	: 'json'
	        }).done(function(data) {
	        	if(data.messages && data.messages.message) {
	        		alert(data.messages.message);
	        	}
	        	
	        	if(data.success) {
	        		btn.closest('.editable-parent').find('a').html(data.data).removeClass('editable-empty').show();
	        		btn.closest('.editable-form').remove();
	        	} else {
	        		alert(data.message);
	        		btn.prop('disabled', false).find('i').attr('class', 'fa fa-check');
	        	}
	        }).fail(function(data) {
	        	if(typeof data.message != 'undefined') {
	        		alert(data.message);
	        		btn.prop('disabled', false).find('i').attr('class', 'fa fa-check');
	        	}
	        });
		});
		
		$('#cj-wrapper').on('keypress', '.editable-input', function(e) {
		    if(e.which == 13) {
		    	$(this).closest('.editable-parent').find('.btn-save').click();
		        return false
		    }
		});
	}
	
	CjSurveyApi.initSurveyResponse = function ()
	{
		var form = $('.survey-form');
		$('.survey-form').on('change', 'select[name="jumptopageid"]', function()
		{
			var value = $(this).val();
			try {value = parseInt(value);} catch(e){}
			if(value <= 0)
			{
				return false;
			}
			
			CjSurveyApi.submitAjaxForm($(this), '#adminForm', 'response.jump', 'onBeforeSaveResponse', 'onAfterSaveResponse');
		});
		
		CjSurveyApi.attachValidators(form.find('#adminForm'));
		CjSurveyApi.processRules(form);
		CjSurveyApi.loadResponsePageComponents(form);
		
		$('.survey-form').on('change', '[name^="answer-"], [name^="free-text-"]', function()
		{
			CjSurveyApi.processRules($(this).closest('.survey-form'));
		});
		
//		$(document).keypress(function(e) 
//		{
//		  if(e.which == 13) 
//		  {
//			  e.preventDefault();
//			  $('.survey-navigation button:visible').click();
//		  }
//		});
		
		$('.survey-form').on('click', '.nps-table a', function(){
			$(this).parent().find('a').removeClass('active');
			$(this).addClass('active');
			$(this).find('input').prop('checked', true);
		});
	};
	
	CjSurveyApi.loadResponsePageComponents = function(form)
	{
		form.find('.datetime input').each(function()
		{
			var dateOptions = {'lang': $(this).data('language'), 'format': $(this).data('format')};
			
			if($(this).data('mindate')) 
			{
				dateOptions.minDate = $(this).data('mindate');
			}
			
			if($(this).data('maxdate')) 
			{
				dateOptions.maxDate = $(this).data('maxdate');
			}
			
			$(this).datetimepicker(dateOptions);
		});

		form.find('[data-toggle="rating"]').each(function(){
			var rating = $(this);
			var styleTheme = rating.data('theme');
			var currentRating = rating.data('score');
			
			rating.closest('.rating-wrapper').find('.cancel-selected-rating').on('click', function(event) {
	            event.preventDefault();
	            rating.barrating('clear');
	            $(this).hide();
	        });

			rating.barrating({
	            theme: styleTheme,
	            showSelectedRating: false,
	            initialRating: currentRating,
	            onSelect: function(value, text) {
	            	if (value) {
		            	rating.closest('.rating-wrapper').find('.selected-rating-text').html(text).show();
		            	rating.closest('.rating-wrapper').find('.cancel-selected-rating').show();
	            	}
	            	else
	            	{
	            		rating.closest('.rating-wrapper').find('.selected-rating-text').hide();
		            	rating.closest('.rating-wrapper').find('.cancel-selected-rating').hide();
	            	}
	            }, 
	            onClear: function(value, text) {
	            	rating.closest('.rating-wrapper').find('.selected-rating-text').hide();
	            }
	        });
		});
		
		if(jQuery().sortable && form.find('.ranking-options').length > 0)
		{
			form.find('.ranking-options').sortable({
				revert: true, 
				placeholder: 'list-group-item', 
				forcePlaceholderSize: true,
				update: function(event, ui) {
					ui.item.closest('.ranking-options').find('.ranking-option').each(function(index, option){
						$(this).find('input').val(index + 1);
					});
				}
			});
		}
		
		form.find('.signature-pad').each(function(){
			var me = $(this);
			var canvas = me.get(0);
			var signaturePad = new SignaturePad(canvas);
			signaturePad.fromDataURL(me.closest('.signature-wrapper').find('input').val());
			
			signaturePad.onEnd = function()
			{
				me.closest('.signature-wrapper').find('input').val(signaturePad.toDataURL());
			};
			
			me.closest('.signature-wrapper').find('.btn-clear-signature').click(function(){
				signaturePad.clear();
				me.closest('.signature-wrapper').find('input').val('');
			});
		});
		
		form.find('.slider-wrapper').each(function(){
			var me = $(this);
			var ctx = $(this).get(0);
			var answers = $.parseJSON(me.parent().find('.answers').html());
			
			noUiSlider.create(ctx, {
				start: [ me.data('min') ],
				step: me.data('step'),
				tooltips: me.data('tooltips') ? true : false,
				format: {
					to: function(value) {
						return Math.round(value);
					},
					from: function(value) {
						return value;
					}
				},
				range: {
					'min': [ me.data('min') ],
					'max': [ me.data('max') ]
				}
			});
			
			ctx.noUiSlider.on('set', function(values, handle){
				me.parent().find('.inputs input[type="radio"]').not(values).prop('checked', false);
				me.parent().find('.inputs input[type="radio"]').eq(values).prop('checked', true);
				me.parent().find('.inputs input[type="text"]').val(values);
			});
			
			if(me.parent().find('.inputs input[type="radio"]:checked').length > 0){
				ctx.noUiSlider.set(me.parent().find('.inputs input[type="radio"]').index(me.parent().find('.inputs input[type="radio"]:checked')));
			}
			
			if(me.parent().find('.inputs input[type="text"]').length > 0){
				ctx.noUiSlider.set(me.parent().find('.inputs input[type="text"]').val());
			}
		});
		
		form.find(".chzn-container").each(function(i, elem) 
		{
			if ($(elem).width() == 0) 
			{
				$(elem).removeAttr('style');
			}
		});
		
		form.find('.qtype_radio_grid td').click(function(){
			$(this).find('input[type="radio"]').prop('checked', true);
		});
		
		form.find('.qtype_checkbox_grid td').click(function(){
			$(this).find('input[type="checkbox"]').prop('checked', function (i, value) {return !value;});
		});
		
//		$('.survey-form').on('click', 'input[type="radio"]', function(){
//		    var oldVal = $(this).data('oldval');
//		    if (oldVal) {
//		    	$(this).prop('checked', !oldVal);
//		    	$(this).data('oldval', !oldVal);
//		    }
//		    else
//		    {
//		    	$(this).data('oldval', true);
//		    	$('.survey-form input[type=radio]:not(:checked)').data('oldval', false);
//		    }
//		});
	}
	
	CjSurveyApi.attachValidators = function(form)
	{
		jQuery.validator.addMethod("data-regex", function(value, element, params) 
		{
			params = JSON.parse(params);
			var regEx = new RegExp(params.regex);
			return this.optional(element) || regEx.test(value);
		}, 
		function(params, element) 
		{
			params = JSON.parse(params);
			return params.message;
		});
		
		$.validator.addMethod('minselect', function(value, element, params)
		{
			var min_selections = params;
			try{min_selections = parseInt(min_selections);}catch(e){min_selections = 0;}
			
			if($(element).attr('data-field-type') == 'grid')
			{
				var name = element.name.substring(0, element.name.lastIndexOf("-") + 1);
				return $('input[name^="'+name+'"][type="radio"]:checked').length >= min_selections;
			} 
			else
			{
				return $('input[name="'+element.name+'"][type="checkbox"]:checked').length >= min_selections;
			}
		}, 
		$.validator.format($('#msg_validation_min_answers_required').text()));
		
		$.validator.addMethod('maxselect', function(value, element, params) 
		{
			var max_selections = params;
			try{max_selections = parseInt(max_selections);}catch(e){max_selections = 0;}
			
			if($(element).attr('data-field-type') == 'grid')
			{
				var name = element.name.substring(0, element.name.lastIndexOf("-") + 1);
				return $('input[name^="'+name+'"][type="radio"]:checked').length <= max_selections;
			}
			else
			{
				return $('input[name="'+element.name+'"][type="checkbox"]:checked').length <= max_selections;
			}
		}, 
		$.validator.format($('#msg_validation_max_answers_required').text()));
		
		form.validate({
			ignore: '.hideme:hidden input, .hideme:hidden select, .hideme:hidden textarea',
			errorPlacement: function(error, element) {
//				error.html($('#default_error_required').html());
				if(element.closest('.question-item').find('label.error').length == 0){
					error.appendTo( element.closest('.question-item').find('.question-header') );
				}
			},
			invalidHandler: function(event, validator) 
			{
				form.find('.alert-validation-error').show();
			},
			success: function(label)
			{
				label.hide();
				if(form.find('label.error').length > 0)
				{
					form.find('.alert-validation-error').hide();
				}
			}
		});
	}
	
	CjSurveyApi.processRules = function(form)
	{
		var shownIds = new Array();
		
		// Rule: Show another question when a question is answered.
		form.find('.question-item[showitems]').each(function()
		{
			if($(this).is(':visible'))
			{
				if(
					$(this).find('input[type="checkbox"][name^="answer-"]:checked, input[type="radio"][name^="answer-"]:checked').length > 0 ||
					$(this).find('input[type="textbox"][name^="answer-"], textarea[name^="answer-"], input[type="textbox"][name^="free-text-"]')
						.filter(function(){return $.trim($(this).val()) == '';}).length > 0 ||
					$(this).find('select[name^="answer-"] option:selected').length > 0
				){
					values = $(this).attr('showitems').split(',');
					$.each(values, function(index, value){
						$('#question-'+value).show();
						shownIds.push('#question-'+value);
					});
				}
			}
		});
		
		// Rule: Show a question when a specified answer is selected.
		form.find('input[showitems]:checked, option[showitems]:selected').each(function()
		{
			if($(this).closest('.question-item').is(':visible'))
			{
				values = $(this).attr('showitems').split(',');
				$.each(values, function(index, value){
					$('#question-'+value).show();
					shownIds.push('#question-'+value);
				});
			}
		});
		
		// Rule: Show a question when a specified textbox answer is entered.
		form.find('input[type="text"][showitems]').filter(function(){ return !!this.value; }).each(function() 
		{
			if($(this).closest('.question-item').is(':visible'))
			{
				values = $(this).attr('showitems').split(',');
				$.each(values, function(index, value){
					$('#question-'+value).show();
					shownIds.push('#question-'+value);
				});
			}
		});
		
		// Rule: Show question when a star rating was selected
		form.find('input[showonrating]').each(function(){
			if($(this).closest('.question-item').is(':visible'))
			{
				var value = 0;
				try{value = parseInt($(this).val());} catch(e){}
				
				if(value > 0)
				{
					var rules = $(this).attr('showonrating').split(',');
					$.each(rules, function(index, rule){
						var parts = rule.split('_');
						if(parts && parts.length == 2 && parts[0] == value)
						{
							$('#question-'+parts[1]).show();
							shownIds.push('#question-'+parts[1]);
						}
					});
				}
			}
		});
		
		// Rule: Hide all questions marked as hidden
		form.find('.hideme').not(shownIds.join(',')).hide();
	}
	
	CjSurveyApi.initQuestionsForm = function()
	{
		$(document).ajaxStart(function()
		{
			$('#survey-main-wrapper').block({
				message: $('#progress-message'),
				css: {
						border: 'none', 
			            padding: '10px', 
			            backgroundColor: '#000', 
			            '-webkit-border-radius': '10px', 
			            '-moz-border-radius': '10px', 
			            opacity: .5, 
			            color: '#fff'
				}
			});
		})
		.ajaxStop(function()
		{
			$('#survey-main-wrapper').unblock();
		});
		
		CjSurveyApi.addSortableFields();

		$('#questions').on('sortupdate', function(event, ui) 
		{
			if(ui.item.hasClass('question'))
			{
				var positions = new Array();
				$('.question').each(function(index)
				{
					positions.push((index + 1) + '_' + $(this).find('input[name="qid"]').val());
				});
				CjSurveyApi.submitAjaxForm(ui, '#questionForm', 'question.reorder', 'onBeforeReorder', 'onAfterReorder', positions);
			}
		});
		
		$('#questions').on('click', '.btn-add-answer', function()
		{
			var form = $(this).closest('form');
			var answer = $(form.find('.tpl-answer').html());
			form.find('.answers').append(answer);
			answer.find('select:not(.chosen-disabled)').chosen();
			
			var min_selections = form.find('select[name="min_selections"]');
			answer_count = min_selections.find('option').length;
			min_selections.append($('<option>', {'value': answer_count}).html(answer_count));
			min_selections.trigger('chosen:updated').trigger('liszt:updated').trigger('change');
			
			var max_selections = form.find('select[name="max_selections"]');
			answer_count = max_selections.find('option').length;
			max_selections.append($('<option>', {'value': answer_count}).html(answer_count));
			max_selections.trigger('chosen:updated').trigger('liszt:updated').trigger('change');
			
			if(form.find('.rank-weights').length > 0)
			{
				var html = form.find('.tpl-rank-weight').html().replace(/%s/g, form.find('.answers .answer').length);
				form.find('.rank-weights').append(html);
			}
		});
		
		$('#questions').on('click', '.btn-add-column', function()
		{
			var form = $(this).closest('form');
			var answer = form.find('.tpl-answer').clone();
			form.find('.columns').append(answer.html());
		});
		
		$('#questions').on('click', '.btn-delete-answer', function()
		{
			$(this).closest('form').find('.rank-weights .rank-weight:last-child').remove();
			$(this).closest('.answer').remove();
		});
		
		$('#questions').on('click', '.btn-close-question', function(){
			$(this).closest('.question').find('a[data-toggle="collapse"]').click();
		});
		
		$('select[name="pageid"]').on('change', function(e)
		{
			var button = $(this);
			CjSurveyApi.submitAjaxForm(button, '#questionForm', 'question.loadpage', 'onBeforeLoadPage', 'onAfterLoadPage'); 
		});
		
		// file upload button function
		$('.questions').on('click', '.btn-choose-image', function()
		{
			var button = $(this);
			$('#input-file-upload').click().off().change(function()
			{
				CjSurveyApi.submitAjaxForm(button, '#file-upload-form', 'question.upload', 'onBeforeAnswerImageUpload', 'onAfterAnswerImageUpload');
			});
        });
		
		$('.questions').on('click', '.btn-move-question', function()
		{
			var text = $('#textMoveQuestion').html()
				.replace("{1}", $(this).closest('.question').find('input[name="title"]').val())
				.replace("{2}", $('select[name="pageid"] option:selected').html());
			$('#modalMoveQuestion .move-question-text').html(text);
			
			$('#modalMoveQuestion select[name="all-pages"]')
				.empty()
				.append($('select[name="pageid"] > option').clone())
				.trigger('chosen:updated')
				.trigger('liszt:updated')
				.trigger('change');
			$('#modalMoveQuestion').modal('show');
			$('#modalMoveQuestion .btn-confirm-move-question').show();
			$('#modalMoveQuestion .btn-confirm-copy-question').hide();
		});
		
		$('.questions').on('click', '.btn-copy-question', function()
		{
			var text = $('#textCopyQuestion').html()
				.replace("{1}", $(this).closest('.question').find('input[name="title"]').val())
				.replace("{2}", $('select[name="pageid"] option:selected').html());
			$('#modalMoveQuestion .move-question-text').html(text);
			
			$('#modalMoveQuestion select[name="all-pages"]')
				.empty()
				.append($('select[name="pageid"] > option').clone())
				.trigger('chosen:updated')
				.trigger('liszt:updated')
				.trigger('change');
			$('#modalMoveQuestion').modal('show');
			$('#modalMoveQuestion .btn-confirm-copy-question').show();
			$('#modalMoveQuestion .btn-confirm-move-question').hide();
		});
		
		$('#modalMoveQuestion .btn-confirm-move-question').off();
		$('#modalMoveQuestion .btn-confirm-copy-question').off();
		
		$('#modalMoveQuestion').on('click', '.btn-confirm-move-question', function()
		{
			var button = $(this);
			CjSurveyApi.submitAjaxForm(button, '#questionForm', 'question.move', 'onBeforeMoveQuestion', 'onAfterMoveQuestion');
			return true;
		});
		
		$('#modalMoveQuestion').on('click', '.btn-confirm-copy-question', function()
		{
			var button = $(this);
			CjSurveyApi.submitAjaxForm(button, '#questionForm', 'question.copy', 'onBeforeMoveQuestion', 'onAfterMoveQuestion');
			return true;
		});
		
		$('.btn-edit-page-title').click(function()
		{
			var newTitle = prompt($('#textPromptPageTitle').html(), '');
			if(newTitle)
			{
				var button = $(this);
				CjSurveyApi.submitAjaxForm(button, '#questionForm', 'question.savepagetitle', 'onBeforeSavePageTitle', 'onAfterSavePageTitle', newTitle);
			}
		});
		
		$('.questions').on('click', 'input[name="rule-name"]', function()
		{
			if($(this).val() == 1 || $(this).val() == 2)
			{
				$(this).closest('.conditional-rules-form').find('.rule-answer, .rule-column, .rule-rating').hide();
			} 
			else 
			{
				var list_answers = $(this).closest('.conditional-rules-form').find('select[name="rule-answer"]').empty();
				list_answers.closest('form').find('.answers input[name="answer"]').each(function()
				{
					var value = $(this).closest('.answer').find('input[name="aid"]').val();
					var answer = $(this).val();
					list_answers.append($('<option>', {'value': value}).html(answer));
				});
				list_answers
					.trigger("liszt:updated")
					.trigger('chosen:updated')
					.trigger('change');

				var list_columns = $(this).closest('.conditional-rules-form').find('select[name="rule-column"]').empty();
				list_columns.closest('form').find('.columns input[name="answer"]').each(function()
				{
					var value = $(this).closest('.answer').find('input[name="aid"]').val();
					var answer = $(this).val();
					list_columns.append($('<option>', {'value': value}).html(answer));
				});
				list_columns
					.trigger("liszt:updated")
					.trigger('chosen:updated')
					.trigger('change');
				
				var list_rating = $(this).closest('.conditional-rules-form').find('select[name="rule-rating"]').empty();
				var num_ratings = $(this).closest('.conditional-rules-form').find('select[name="rule-rating"]').attr('data-num-rating');
				try{num_ratings = parseInt(num_ratings);}catch(e){num_ratings = 5;}
				for(var i = 1; i <= num_ratings; i++)
				{
					list_rating.append($('<option>', {'value': i, html: i + ' ' + Array(i + 1).join('<i class="fa fa-star">&zwnj;</i>')}));
				};
				list_rating
					.trigger("liszt:updated")
					.trigger('chosen:updated')
					.trigger('change');
				
				$(this).closest('.conditional-rules-form').find('.rule-answer, .rule-column, .rule-rating').show();
			}
			
			if($(this).val() == 1 || $(this).val() == 3)
			{
				var list_show_questions = $(this).closest('.conditional-rules-form').find('select[name="rule-show-question"]').empty();
				$('#questions').find('.question').each(function()
				{
					var qid = $(this).find('input[name="qid"]').val();
					var title = $(this).find('.question-title').html();
					list_show_questions.append($('<option>', {'value': qid}).html(title));
				});
				
				list_show_questions
					.trigger("liszt:updated")
					.trigger('chosen:updated')
					.trigger('change');
				$(this).closest('.conditional-rules-form').find('.rule-show-question').show();
			} 
			else 
			{
				$(this).closest('.conditional-rules-form').find('.rule-show-question').hide();
			}
			
			$(this).closest('.conditional-rules-form').find('.rule-criteria').insertAfter($(this).parent()).slideDown();
		});
		
		$('.btn-reorder-pages').click(function(){
			$('#modalReorderPages').modal('show');
		});
		
		if(jQuery().sortable && $('.reorder-pages-list').length > 0)
		{
			$('.reorder-pages-list').sortable({revert: true, placeholder: 'well well-small', forcePlaceholderSize: true});
		}
		
		$('.btn-corfirm-reorder-pages').click(function(){
			var pages = new Array();
			$('.sortpage').each(function(index)
			{
				pages.push($(this).find('input[name="sortpageid"]').val());
			});
			CjSurveyApi.submitAjaxForm($(this), '#questionForm', 'question.reorderpages', 'onBeforePageReorder', 'onAfterPageReorder', pages);
			$('#modalReorderPages').modal('hide');
		});
	};
	
	CjSurveyApi.initReports = function()
	{
		if(jQuery().datetimepicker)
		{
			$('.report-filter').find('.datetime input').each(function(){
				var format = $(this).data('format');
				var language = $(this).data('language');
				$(this).datetimepicker({'lang': language, 'format': format});
			});
		}
		
		$('.consolidated-report .grid-table tbody tr').each(function() {
			var $td = $(this).children('td:not(:first)');
		    var vals = $td.map(function() {
		        return +$(this).text();
		    }).get();
		    var max = Math.max.apply(Math, vals);
		    $td.filter(function() {
		        return +$(this).text() === max;
		    }).addClass('highlight');
		});
		
		$('[data-toggle="rating"]').each(function(){
			var rating = $(this);
			var styleTheme = rating.data('theme');
			var currentRating = rating.data('score');

			rating.barrating({
	            theme: styleTheme,
	            readonly: true,
	            initialRating: currentRating
	        });
		});
		
		$('.toggle-charts-button').click(function(){
			$('.grid-reports-table, .grid-reports-charts').toggle('slow');
		});
		
		// results section
		$('#cj-wrapper .survey-result-question').each(function(){
			var question = $(this);
			question.find('.selected-answer').prependTo(question);
		});
		
		$('.nps-chart').each(function(){
			var ctx = $(this).get(0);
			var data = $.parseJSON($(this).closest('.nps-container').find('.nps-scores').html()).map(Number);
			var labels = $.parseJSON($(this).closest('.nps-container').find('.nps-labels').html());
			var colors = ["rgba(255, 99, 132, 0.2)","rgba(255, 99, 132, 0.2)","rgba(255, 99, 132, 0.2)","rgba(255, 99, 132, 0.2)","rgba(255, 99, 132, 0.2)",
				"rgba(255, 99, 132, 0.2)","rgba(255, 205, 86, 0.2)","rgba(255, 205, 86, 0.2)","rgba(75, 192, 192, 0.2)","rgba(75, 192, 192, 0.2)"];
			var borderColors = ["rgb(255, 99, 132)","rgb(255, 99, 132)","rgb(255, 99, 132)","rgb(255, 99, 132)","rgb(255, 99, 132)",
				"rgb(255, 99, 132)","rgb(255, 205, 86)","rgb(255, 205, 86)","rgb(75, 192, 192)","rgb(75, 192, 192)"];
			
			var myNpsChart = new Chart(ctx, {
			    "type": "bar",
			    "data": {
			    	"labels": labels,
			    	"datasets":[{
			    		"data": data,
			    		"fill": false,
			    		"backgroundColor": colors,
			    		"borderColor": borderColors,
			    		"borderWidth": 1
			    	}]
			    },
			    "options":{
			    	"scales":{
			    		"yAxes":[{
			    			"ticks":{
			    				"beginAtZero":true
			    			}
			    		}],
			    		"xAxes":[{
			    			"ticks": {
			    				"stepSize": 1
			    			}
			    		}]
			    	},
			    	legend: {
			            display: false
			    	}
			    }
			});
		});
		
		// filters
		if($('#filter-rules-builder').length > 0)
		{
			$('#filter-rules-builder').queryBuilder({
				plugins: ['bt-tooltip-errors'],
				allow_groups: false,
				conditions: ['AND'],
				filters: $.parseJSON($('#filter-rules-json').text()),
				operators: ['equal'],
				rules: $.parseJSON($('#filter-rules-basic').text())
			});
		}
		
		// responses listing for admin
		$('.btn-add-comment').click(function(){
			var button = $(this);
			$('#commentform').find('.messages').hide();
			$('#commentform').find('input[name="rid"]').val(button.data('rid'));
			$('#commentform').find('textarea[name="comment"]').val(button.closest('.comments-wrap').find('.comment').html());
			$('#commentform').appendTo(button.closest('.comments-wrap')).show();
			button.hide();
		});
		
		$('.btn-comment-cancel').click(function(){
			$(this).closest('.comments-wrap').find('#commentform').hide();
			$(this).closest('.comments-wrap').find('.btn-add-comment').show();
		});
		
		$('.btn-comment-submit').click(function(){
			var form = $('#commentform');
			var button = $(this);
			$('#commentform').find('.messages').html('').hide();
			var formData = {
				'rid'		: form.find('input[name="rid"]').val(),
				'comment'	: form.find('textarea[name="comment"]').val()
			};
			
			$.ajax({
	            type		: 'POST',
	            url			: $('#commentform').attr('action'),
	            data		: formData,
	            dataType	: 'json',
	            encode		: true
	        }).done(function(data) {
	        	if(data.messages && data.messages.message)
				{
	        		$('#commentform').find('.messages').html(data.messages.message).show();
				}
	        	
				if(data.success)
				{
					button.closest('.comments-wrap').find('.comment').show().html(data.data.description);
					form.find('textarea[name="comment"]').val('')
				}
				else
				{
					$('#commentform').find('.messages').html(data.message).show();
				}
				$('.btn-comment-cancel').click();
            }).fail(function(data){
            	alert(data.message);
            });
	    });
		
		$('.btn-print-pdf').click(function(){
			var btnObj = $(this);
			var iframeId = 'rptiFrame';
			var $iframe = $('iframe#rptiFrame');

			btnObj.prop('disabled', true).find('i').attr('class', 'fa fa-circle-o-notch fa-spin fa-fw');
			$iframe.attr('src', $(this).data('url'));

			$iframe.load(function() {
				btnObj.prop('disabled', false).find('i').attr('class', 'fa fa-file-pdf-o');
			});
		});
	};
	
	CjSurveyApi.buildRules = function(task)
	{
		var rules = $('#filter-rules-builder').queryBuilder('getRules');
		if(null != rules)
		{
			$('#filter_conditions').val(JSON.stringify(rules));
		}
		else
		{
			$('#filter_conditions').val('');
		}

		return true;
	};
	
	CjSurveyApi.initInvite = function()
	{
		$('#contact-groups-wrapper').on('click', '.checkall', function()
		{
			var checked = $(this).prop('checked');
			$(this).closest('table').find('input.checkbox').prop('checked', checked);
		});
		
		$('.contacts-import-modal').find('.btn-select-csv-file').click(function()
		{
			$('#import_contacts_form').find('#csvfile').click().change(function()
			{
				$('.contacts-import-modal').find('.csv_filename_label').html($(this).val().split('\\').pop());
			});
		});
		
		$('#contact-groups-wrapper').on('click', '#btn-assign-contacts', function()
		{
			$('#inviteForm').find('#assignAction').val('1');
			$('#assign-contacts-modal').find('.assign-contacts-wraper').empty().append($('.contact-groups-listbox').html());
		});
		
		$('#contact-groups-wrapper').on('click', '#btn-unassign-contacts', function()
		{
			$('#inviteForm').find('#assignAction').val('0');
			$('#assign-contacts-modal').find('.assign-contacts-wraper').empty().append($('.contact-groups-listbox').html());
		});
		
		$('#contact-groups-wrapper').on('click', '.btn-assign-contacts', function()
		{
			$('[href="#tabContacts"]').tab('show');
		});
		
		$('#contact-groups-wrapper [name="filter_group_id"]').change(function()
		{
			var button = $(this);
			CjSurveyApi.submitAjaxForm(button, '#inviteForm', 'invite.getcontacts', 'onBeforeLoadContacts', 'onAfterLoadContacts'); return false;
		});
		
		// Users selector box functions
		$('.users-selector input[name="filter_username"]').on('input', function()
		{
			CjSurveyApi.submitAjaxForm(this, '#inviteForm', 'invite.getusers', 'onBeforeGetRegisteredUsers', 'onAfterGetRegisteredUsers');
		});
		
		$('.user-selector-box').on('click', '.list-group-item', function()
		{
			$(this).toggleClass('list-group-item-info').find('i').toggleClass('fa-circle-thin fa-check-circle-o');
		});
		
		$('.user-selector-box .us-buttons .btn-move-right').click(function()
		{
			$('.user-selector-box .users-available').find('.list-group-item-info').appendTo($('.user-selector-box .users-selected'))
				.removeClass('list-group-item-info')
				.find('i').attr('class', 'fa fa-circle-thin');
		});
		
		$('.user-selector-box .us-buttons .btn-move-all-right').click(function()
		{
			$('.user-selector-box .users-available').find('.list-group-item').appendTo($('.user-selector-box .users-selected'))
				.removeClass('list-group-item-info')
				.find('i').attr('class', 'fa fa-circle-thin');
		});
		
		$('.user-selector-box .us-buttons .btn-move-left').click(function()
		{
			$('.user-selector-box .users-selected').find('.list-group-item-info').appendTo($('.user-selector-box .users-available'))
				.removeClass('list-group-item-info')
				.find('i').attr('class', 'fa fa-circle-thin');;
		});
		
		$('.user-selector-box .us-buttons .btn-move-all-left').click(function()
		{
			$('.user-selector-box .users-selected').find('.list-group-item').appendTo($('.user-selector-box .users-available'))
				.removeClass('list-group-item-info')
				.find('i').attr('class', 'fa fa-circle-thin');
		});
		
		$('.user-selector-box .btn-select-all-users').click(function()
		{
			$(this).closest('.us-box').find('.users-list').find('a').addClass('list-group-item-info').find('i').attr('class', 'fa fa-check-circle-o');
		});
		
		$('.user-selector-box .btn-deselect-all-users').click(function()
		{
			$(this).closest('.us-box').find('.users-list').find('a').removeClass('list-group-item-info').find('i').attr('class', 'fa fa-circle-thin');
		});
	};
	
	/////////////////////////// Editors //////////////////////////////////
	CjSurveyApi.attachEditors = function()	{
		if(typeof Joomla.JoomlaTinyMCE != 'undefined') {
			try	{
				var pluginOptions = Joomla.getOptions ? Joomla.getOptions('plg_editor_tinymce', {})
						:  (Joomla.optionsStorage.plg_editor_tinymce || {});
				Joomla.JoomlaTinyMCE.setupEditors();
			}
			catch (e) {}
		} else if(typeof tinyMCE != 'undefined') {
			$('#cj-wrapper').find('.js-editor-tinymce textarea').each(function(){
				var targetId = $(this).attr('id');
				try
				{
					tinymce.EditorManager.execCommand('mceRemoveEditor', false, targetId);
				}
				catch (e) {}
				
				try
				{
					tinymce.EditorManager.execCommand('mceAddEditor', false, targetId);
				}
				catch (e) {
					console.log(e);
				}
			});
		}
	}
	
	CjSurveyApi.attachEditor = function(target)	{
		if(typeof Joomla.JoomlaTinyMCE != 'undefined' && $('#'+target).length > 0) {
			try	{
				CjSurveyApi.detachEditor(target);
				var pluginOptions = Joomla.getOptions ? Joomla.getOptions('plg_editor_tinymce', {})
						:  (Joomla.optionsStorage.plg_editor_tinymce || {});
				Joomla.JoomlaTinyMCE.setupEditor(document.getElementById(target), pluginOptions);
			}
			catch (e) {}
		} else if(typeof tinyMCE != 'undefined') {
			try
			{
				tinymce.EditorManager.execCommand('mceRemoveEditor', false, target);
			}
			catch (e) {}
			
			try
			{
				tinymce.EditorManager.execCommand('mceAddEditor', false, target);
			}
			catch (e) {
				console.log(e);
			}
		}
	};
	
	CjSurveyApi.detachEditor = function(target) {
		if (
				(typeof(tinyMCE) != 'undefined') &&
				(
					(typeof tinyMCE.getInstanceById == 'function' && tinyMCE.getInstanceById(target)) || 
					(window.tinyMCE.get(target))
				)
		) {
			try {
				tinymce.EditorManager.execCommand('mceRemoveEditor', false, target);
			}
			catch (e) {}
		}
	};
	
	CjSurveyApi.setEditorContent = function(target, content) {
		if(typeof tinyMCE != 'undefined' && tinymce.get(target) != null) {
			tinymce.get(target).setContent(content);
		} else {
			$('#'+target).html(content);
		}
	};
	
	CjSurveyApi.refreshEditor = function() {
        if(typeof tinyMCE != 'undefined') {
        	tinyMCE.triggerSave(true, true);
        }
	};
	/////////////////////////// Editors //////////////////////////////////
	
	CjSurveyApi.onBeforeCreateResponse = function(action, button, form, data)
	{
		$.blockUI({
			message: $('#progress-message'),
			css: {
					border: 'none', 
		            padding: '10px', 
		            backgroundColor: '#000', 
		            '-webkit-border-radius': '10px', 
		            '-moz-border-radius': '10px', 
		            opacity: .5, 
		            color: '#fff'
			}
		});
		
		return true
	};
	
	CjSurveyApi.onAfterCreateResponse = function(action, button, form, data)
	{
		var container = button.closest('.survey-wrapper');
		container.find('.captcha-form').remove();
		container.find('input[name="rid"]').val(data.data.responseId);
		CjSurveyApi.onAfterSaveResponse(action, button, form, data);
		
		return true;
	};
	CjSurveyApi.onBeforeApplyResponse = function(action, button, form, data)
	{
		return CjSurveyApi.onBeforeSaveResponse(action, button, form, data);
	}
	
	CjSurveyApi.onAfterApplyResponse = function(action, button, form, data)
	{
		$.unblockUI();
		return true;
	}
	
	CjSurveyApi.onBeforeSaveResponse = function(action, button, form, data)
	{
		var container = button.closest('.survey-wrapper');
		if(!$(form).valid())
		{
			container.find('.alert-validation-error').show();
			return false;
		}
		else
		{
			container.find('.alert-validation-error').hide();
		}
		
		$.blockUI({
			message: $('#progress-message'),
			css: {
					border: 'none', 
		            padding: '10px', 
		            backgroundColor: '#000', 
		            '-webkit-border-radius': '10px', 
		            '-moz-border-radius': '10px', 
		            opacity: .5, 
		            color: '#fff'
			}
		});
		
		return true;
	};
	
	CjSurveyApi.onAfterSaveResponse = function(action, button, form, data)
	{
		var container = button.closest('.survey-wrapper');
		if(data.data.finished)
		{
			container.find('.survey-navigation').remove();
			container.find('.survey-pagination').remove();
			
			if($.trim(data.data.redirect_url) != '')
			{
				window.location.replace($.trim(data.data.redirect_url));
			}
			else
			{
				container.find('.questions').hide().html(data.data.html).fadeIn(1000);
				container.find('.survey-custom-header').remove();
			}
			
			$('[data-toggle="rating"]').each(function(){
				var rating = $(this);
				var styleTheme = rating.data('theme');
				var currentRating = rating.data('score');

				rating.barrating({
		            theme: styleTheme,
		            readonly: true,
		            initialRating: currentRating
		        });
			});
		}
		else
		{
			container.find('.btn-create').remove();
			container.find('.btn-finish').toggle(!data.data.hasNext);
			container.find('.btn-save').toggle(true);
			container.find('.btn-next').toggle(data.data.hasNext);
			container.find('.btn-previous').toggle(data.data.hasPrev)
			container.find('.captcha-form').remove();
			
			form.find('.survey-pagination').html(data.data.pagination);
			form.find('.questions').hide().html(data.data.html).fadeIn(1000, function(){
				CjSurveyApi.attachEditors();
			});
			
			// data loaded, now execute page rules
			CjSurveyApi.processRules(form);
			
			// load all components
			CjSurveyApi.loadResponsePageComponents(form);
		}
		
		container.find('.survey-description, .confidential-notice').hide();
		if(container.find('.survey-body').find('.survey-title').length == 0 && container.find('.survey-body').find('.social-sharing').length == 0)
		{
			container.find('.survey-body').hide();
		}
		
		form.find('select:not(.chosen-disabled)').chosen();
		
		$('html,body').animate({scrollTop: $('#cj-wrapper').offset().top},'slow');
		$.unblockUI();
		
		return true;
	};
	
	CjSurveyApi.onBeforeAnswerImageUpload = function(action, button, form, data)
	{
		button.find('i').addClass('fa-spinner fa-spin').removeClass('fa-upload');
		return true;
	};
	
	CjSurveyApi.onAfterAnswerImageUpload = function(action, button, form, data)
	{
		button.closest('.thumbnail').find('.img-answer').attr('src', data.data.url);
		button.closest('.thumbnail').find('input[name="image"]').val(data.data.filename);
		button.find('i:first').addClass('fa fa-upload').removeClass('fa-spinner fa-spin');
		return true;
	};
	
	CjSurveyApi.onBeforeAddQuestion = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onAfterAddQuestion = function(action, button, form, data)
	{
		var question = $(data.data);
		$('#survey-main-wrapper').find('.questions').append(question);
		CjSurveyApi.attachEditor(question.find('textarea').attr('id'));
		question.find('select:not(.chosen-disabled)').chosen();
		return true;
	};

	CjSurveyApi.onBeforeSaveQuestion = function(action, button, form, data)
	{
		$('.messages').prependTo(form);
		
		var qtype = form.find('input[name="qtype"]').val();
		var answers = new Array();
		var columns = new Array();
		var order = 1;
		
		form.find('.answers').find('.answer').each(function(index)
		{
			var answer = $(this);
			var title = $.trim(answer.find('input[name="answer"]').val());
			var image = $.trim(answer.find('input[name="image"]').val());
			var id = $.trim(answer.find('input[name="aid"]').val());
			
			if(title.length > 0)
			{
				answers.push(id+'_'+order);
				answer.find('input[type="hidden"][class="answerTitle"], input[type="hidden"][class="answerImage"]').remove();
				answer.append($('<input>', {'type': 'hidden', 'class': 'answerTitle', 'name': 'title_'+order}).val(title));
				answer.append($('<input>', {'type': 'hidden', 'class': 'answerImage', 'name': 'image_'+order}).val(image));
				order++;
			}
		});
		
		if(qtype == 5 || qtype == 6 || qtype == 17)
		{
			order = 1;
			form.find('.columns').find('.answer').each(function(index)
			{
				var answer = $(this);
				var id = $.trim(answer.find('input[name="aid"]').val());
				var title = $.trim(answer.find('input[name="answer"]').val());
				if(title.length > 0)
				{
					columns.push(id+'_'+order);
				}
				
				answer.find('input[type="hidden"][class="answerTitle"]').remove();
				answer.append($('<input>', {'type': 'hidden', 'class': 'answerTitle', 'name': 'col_title_'+order}).val(title));
				order++;
			});				
		}
		
		form.find('input[name="answers"]').val(JSON.stringify(answers));
		form.find('input[name="columns"]').val(JSON.stringify(columns));
	};
	
	CjSurveyApi.onAfterSaveQuestion = function(action, button, form, data)
	{
		var question = $(data.data);
		CjSurveyApi.detachEditor(button.closest('.question').find('textarea[name="description"]'));
		button.closest('.question').replaceWith(question);
		CjSurveyApi.attachEditor(question.find('textarea').attr('id'));
		CjSurveyApi.addSortableFields();
		question.find('select:not(.chosen-disabled)').chosen();
	};
	
	CjSurveyApi.onBeforeDeleteQuestion = function(action, button, form, data)
	{
		if( window.confirm($('#msg-confirm-alert').html()) )
		{
			return true;
		}
		return false;
	};
	
	CjSurveyApi.onAfterDeleteQuestion = function(action, button, form, data)
	{
		button.closest('.question').remove();
		return true;
	};
	
	CjSurveyApi.onBeforeMoveQuestion = function(action, button, form, data)
	{
		form.find('input[name="newpid"]').val($('#modalMoveQuestion select[name="all-pages"]').val());
		return true;
	};
	
	CjSurveyApi.onAfterMoveQuestion = function(action, button, form, data)
	{
		$('#modalMoveQuestion').modal('hide');
		$('select[name="pageid"]').trigger('change');
		return true;
	};
	
	CjSurveyApi.onBeforeAddPage = function(action, button, form, data)
	{
		//do nothing
		return true;
	};
	
	CjSurveyApi.onAfterAddPage = function(action, button, form, data)
	{
		$('select[name="pageid"]')
			.append($('<option>').val(data.data.pid).html(data.data.title))
			.val(data.data.pid)
			.trigger('chosen:updated')
			.trigger('liszt:updated')
			.trigger('change');
		
		form.find('input[name="pid"]').val(data.data.pid);
		return true;
	};
	
	CjSurveyApi.onBeforeDeletePage = function(action, button, form, data)
	{
		if( window.confirm($('#msg-confirm-alert').html()) )
		{
			var selected = $('select[name="pageid"] option:selected').length;
			if(selected > 0)
			{
				form.find('input[name="pid"]').val($('select[name="pageid"] option:selected').val());
				return true;
			}
		}
		
		return false;
	};
	
	CjSurveyApi.onAfterDeletePage = function(action, button, form, data)
	{
		$('select[name="pageid"] option:selected').remove();
		$('select[name="pageid"]')
			.val($('select[name="pageid"] option:first').val())
			.trigger('chosen:updated')
			.trigger('liszt:updated')
			.trigger('change');
		
		form.find('input[name="pid"]').val($('select[name="pageid"]').val());
		return true;
	};
	
	CjSurveyApi.onBeforeLoadPage = function(action, control, form, data)
	{
		form.find('input[name="pid"]').val(control.val());
		return true;
	};
	
	CjSurveyApi.onAfterLoadPage = function(action, control, form, data)
	{
		$('#questions').find('.question').remove();
		$('#questions').prepend(data.data.html);
		$('#questions').find('select:not(.chosen-disabled)').chosen();
		CjSurveyApi.attachEditors();
		CjSurveyApi.addSortableFields();
		return true;
	};
	
	CjSurveyApi.onBeforeSavePageTitle = function(action, control, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onAfterSavePageTitle = function(action, control, form, data)
	{
		$('select[name="pageid"] option:selected')
			.html(data.data)
			.trigger('chosen:updated')
			.trigger('liszt:updated');
		
		return true;
	};
	
	CjSurveyApi.onBeforePageReorder = function(action, control, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onAfterPageReorder = function(action, control, form, data)
	{
		location.reload();
		return true;
	};
	
	CjSurveyApi.onBeforeReorder = function(action, control, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onAfterReorder = function(action, control, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onBeforeSaveRule = function(action, control, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onAfterSaveRule = function(action, control, form, data)
	{
		tbody = form.find('.rules-table').find('tbody').empty();
		$.each(data.data, function(idx){
			var rule = $(this)[0];
			tr = $('<tr>');
			tr.append($('<td>').html(rule.description));
			tr.append($('<td>').html($('.tpl-delete-rule').html()));
			tr.find('input[name="item_rule_id"]').val(rule.id);
			tbody.append(tr);
		});
		return true;
	};
	
	CjSurveyApi.onBeforeDeleteRule = function(action, control, form, data)
	{
		var ruleid = control.parent().find('input[name="item_rule_id"]').val();
		form.find('input[name="rule_id"]').val(ruleid);
		return true;
	};
	
	CjSurveyApi.onAfterDeleteRule = function(action, control, form, data)
	{
		control.closest('tr').remove();
		return true;
	};
	
	CjSurveyApi.onBeforeGetTextAnswers = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onAfterGetTextAnswers = function(action, button, form, data)
	{
		$('#modalTextAnswers .modal-body').html(data.data);
		$('#modalTextAnswers').modal('show')
		return true;
	};
	
	CjSurveyApi.onBeforeInviteUserGroups = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onAfterInviteUserGroups = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onBeforeInviteCommunityGroups = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onAfterInviteCommunityGroups = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onBeforeInviteContactGroups = function(action, button, form, data)
	{
		if($('.contact-groups-table').find('[name="jform[cgroup_id][]"]:checked').length == 0)
		{
			var n = noty({text: $('#msg_select_required_items').html(), type: 'error', theme: 'relax', timeout: 5000, dismissQueue: false, killer: true});
			return false;
		}
		return true;
	};
	
	CjSurveyApi.onAfterInviteContactGroups = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onBeforeSaveContactGroup = function(action, button, form, data)
	{
		if($('#jform_group_name').val() == '')
		{
			var n = noty({text: $('#msg_missing_required_fields').html(), type: 'error', theme: 'relax', timeout: 5000, dismissQueue: false, killer: true});
			return false;
		}
		return true;
	};
	
	CjSurveyApi.onAfterSaveContactGroup = function(action, button, form, data)
	{
		$('#tabContactGroups .contact-groups-listing').html(data.data);
		$('#cgroup-form-modal').modal('hide');
		return true;
	};
	
	CjSurveyApi.onBeforeDeleteContactGroup = function(action, button, form, data)
	{
		if(confirm($('#msg_confirm_action').html()))
		{
			button.find('i').attr('class', 'fa fa-spin fa-spinner');
			return true;
		}
		return false;
	};
	
	CjSurveyApi.onAfterDeleteContactGroup = function(action, button, form, data)
	{
		$('#tabContactGroups .contact-groups-listing').html(data.data);
		return true;
	};
	
	CjSurveyApi.onBeforeSaveContacts = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onAfterSaveContacts = function(action, button, form, data)
	{
		$('#tabContacts .contacts-listing').html(data.data);
		$('#contacts-form-modal').modal('hide');
		return true;
	};
	
	CjSurveyApi.onBeforeImportContacts = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onAfterImportContacts = function(action, button, form, data)
	{
		$('#tabContacts .contacts-listing').html(data.data);
		$('#contacts-import-modal').modal('hide');
		$('#import_contacts_form').find('#csvfile').val('');
		$('.contacts-import-modal').find('.csv_filename_label').html('');
		return true;
	};
	
	CjSurveyApi.onBeforeDeleteContacts = function(action, button, form, data)
	{
		if(confirm($('#msg_confirm_action').html()))
		{
			button.find('i').attr('class', 'fa fa-spin fa-spinner');
			return true;
		}
		return false;
	};
	
	CjSurveyApi.onAfterDeleteContacts = function(action, button, form, data)
	{
		$('#tabContacts .contacts-listing').html(data.data);
		return true;
	};
	
	CjSurveyApi.onBeforeAssignContacts = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onAfterAssignContacts = function(action, button, form, data)
	{
		$('#assign-contacts-modal').modal('hide');
		$('#tabContactGroups .contact-groups-listing').html(data.data);
		return true;
	};
	
	CjSurveyApi.onBeforeLoadContacts = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onAfterLoadContacts = function(action, button, form, data)
	{
		$('#tabContacts .contacts-listing').html(data.data);
		return true;
	};
	
	CjSurveyApi.onBeforeGetPrevContacts = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onBeforeGetNextContacts = function(action, button, form, data)
	{
		return true;
	};
	
	CjSurveyApi.onBeforeGetRegisteredUsers = function(action, button, form, data)
	{
		if(button.val().length < 2)
		{
			return false;
		}
		return true;
	};
	
	CjSurveyApi.onAfterGetRegisteredUsers = function(action, button, form, data)
	{
		button.closest('.users-selector').find('.users-available').empty();
		if(data.data.length > 0)
		{
			$.each(data.data, function(index, user)
			{
				if($('.users-selector').find('.users-selected').find('#'+user.id).length == 0)
				{
					$('.users-selector').find('.users-available').append(
						$('<a id="'+user.id+'" href="#" class="list-group-item" onclick="return false"><i class="fa fa-circle-thin"></i> '+
								user.name+' ('+user.username+')</a>')
					);
				}
			});
		}
			
		return true;
	};
	
	CjSurveyApi.onBeforeInviteRegisteredUsers = function(action, button, form, data)
	{
		$('#users_selected').empty();
		$('.users-selector').find('.users-selected').find('a').each(function()
		{
			var id = $(this).attr('id');
			$('#users_selected').append($('<option>', {'value': id, 'selected': 'selected'}).html('dummy'));
		});
		return true;
	};
	
	CjSurveyApi.onAfterInviteRegisteredUsers = function(action, button, form, data)
	{
		$('.users-selector').find('.users-selected').empty();
		return true;
	};
	
	CjSurveyApi.onBeforeCreateUniqueUrls = function(action, button, form, data)
	{
		return true;
	}
	
	CjSurveyApi.onAfterCreateUniqueUrls = function(action, button, form, data)
	{
		$('#blkUniqueSurveyUrls').fadeOut('slow', function()
		{
			$(this).children('.panel-body .card-body').html(data.data);
			$('#blkUniqueSurveyUrls').fadeIn('slow');
		});
		return true;
	}
	
	CjSurveyApi.addSortableFields = function()
	{
		if(jQuery().sortable && ($('.answers, .columns').length > 0 || $('#questions').length > 0)) 
		{
			$('.answers, .columns').sortable({revert: true, handle: '.btn-sort-answer', placeholder: 'well well-small', forcePlaceholderSize: true});
			$('#questions').sortable({revert: true, handle: '.btn-sort-question', placeholder: 'well well-small', forcePlaceholderSize: true});
		}
		
		$('#questions').find('.datetime input').each(function()
		{
			var format = $(this).data('format');
			var language = $(this).data('language');
			$(this).datetimepicker({'lang': language, 'format': format});
		});
	};
	
	CjSurveyApi.submitAjaxForm = function(buttonObj, formName, action, triggerBefore, triggerAfter, customData)
	{
		var button = $(buttonObj);
		var form = button.closest(formName).length > 0 ? button.closest(formName) : $(formName);
		var url = form.attr('action');
		
//		CjSurveyApi.refreshEditor();
//    	CjSurveyApi.form_submitted = CjSurveyApi.executeFunctionByName(triggerBefore, CjSurveyApi, action, button, form, null);
		
		customData = customData ? customData : '';
		form.find('input[name="task"]').val(action);
		
//		var data = form.serializeArray();
//		data.push({name: 'data', value: customData});
		
		form.ajaxSubmit({
	        type			: 'POST',
	        dataType		: 'json',
	        url				: url + (/\?/.test(url) ? '&' : '?') +'format=json',
	        data			: {data: customData},
	        encode			: true,
	        beforeSerialize	: function(jqForm, options) 
	        {
	        	CjSurveyApi.refreshEditor();
	        	CjSurveyApi.form_submitted = CjSurveyApi.executeFunctionByName(triggerBefore, CjSurveyApi, action, button, form, null);
        		return CjSurveyApi.form_submitted;
	        },
	        success: function(data, status, xhr, jqForm)
	        {
	        	var messages = new Array();
	        	if(data.message)
	        	{
	        		messages.push(data.message);
	        	}
	        	
	        	if(data.messages && typeof data.messages.message != 'undefined')
				{
	        		$.merge(messages, data.messages.message);
				}
	        	
				$.each(messages, function(index, message)
				{
					var n = noty({text: message, type: 'information', theme: 'relax', timeout: 5000, maxVisible: 10});
				});

				var container = button.closest('.survey-wrapper');
				if(data.success)
				{
					container.find('.messages').hide();
					CjSurveyApi.executeFunctionByName(triggerAfter, CjSurveyApi, action, button, form, data);
				}
				else
				{
					if(container.find('.captcha-form').length > 0 && typeof grecaptcha != 'undefined') {
						grecaptcha.reset();
					}

					form.find('.messages').html(data.message).show();
				}
				
				CjSurveyApi.form_submitted = false;
				$.unblockUI();
	        },
	        error: function (xhr, status, error)
	        {
	        	form.find('.messages').html(error.message).show();
		    	CjSurveyApi.form_submitted = false;
		    	$.unblockUI();
	        }
	    });
	};
	
	CjSurveyApi.executeFunctionByName = function(functionName, context, args) 
	{
		var args = [].slice.call(arguments).splice(2, 5);
		var namespaces = functionName.split(".");
		var func = namespaces.pop();
	
		for(var i = 0; i < namespaces.length; i++) 
		{
			context = context[namespaces[i]];
		}
		return context[func].apply(this, args);
	};
})(jQuery);

jQuery(document).ready(function($)
{
	$('body').on('mouseover', '[data-toggle="tooltip"]', function(){
		this.show = null; this.hide = null;
		$(this).tooltip('show');
	});
	
	//	CjSurveyApi.init_global();
	switch($('#cjpageid').val())
	{
		case 'survey_list':
		case 'category':
			CjSurveyApi.initSurveyList();
			break;
		case 'survey_response':
			CjSurveyApi.initSurveyResponse();
			break;
		case 'questions_form':
			CjSurveyApi.initQuestionsForm();
			break;
		case 'reports':
			CjSurveyApi.initReports();
			break;
		case 'invite':
			CjSurveyApi.initInvite();
			break;
		case 'translations':
			CjSurveyApi.initTranslations();
			break;
	}
});

function sortByClass(a, b) {
    return a.className < b.className;
 }