<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

use Joomla\Utilities\ArrayHelper;

// Base this model on the backend version.
require_once JPATH_ADMINISTRATOR . '/components/com_communitysurveys/models/survey.php';

class CommunitySurveysModelForm extends CommunitySurveysModelSurvey
{
	public $typeAlias = 'com_communitysurveys.survey';

	protected function populateState ()
	{
		$app = JFactory::getApplication();
		
		// Load state from the request.
		$pk = $app->input->getInt('s_id');
		$this->setState('survey.id', $pk);
		
		$this->setState('survey.catid', $app->input->getInt('catid'));
		
		$return = $app->input->get('return', null, 'base64');
		$this->setState('return_page', base64_decode($return));
		
		// Load the parameters.
		$params = $app->getParams();
		$this->setState('params', $params);
		
		$this->setState('layout', $app->input->getString('layout'));
	}

	public function getItem ($itemId = null)
	{
		$itemId = (int) (! empty($itemId)) ? $itemId : $this->getState('survey.id');
		
		// Get a row instance.
		$table = $this->getTable();
		
		// Attempt to load the row.
		$return = $table->load($itemId);
		
		// Check for a table object error.
		if ($return === false && $table->getError())
		{
			$this->setError($table->getError());
			
			return false;
		}
		
		$properties = $table->getProperties(1);
		$value = ArrayHelper::toObject($properties, 'JObject');
		
		// Convert attrib field to Registry.
		$value->params = new JRegistry();
		$value->params->loadString($value->attribs);
		
		// Convert the params field to an array.
		$registry = new JRegistry;
		$registry->loadString($value->attribs);
		$value->attribs = $registry->toArray();
		
		// Compute selected asset permissions.
		$user = JFactory::getUser();
		$userId = $user->get('id');
		$asset = 'com_communitysurveys.survey.' . $value->id;
		
		// Check general edit permission first.
		if ($user->authorise('core.edit', $asset))
		{
			$value->params->set('access-edit', true);
		}
		
		// Now check if edit.own is available.
		elseif (! empty($userId) && $user->authorise('core.edit.own', $asset))
		{
			// Check for a valid user and that they are the owner.
			if ($userId == $value->created_by)
			{
				$value->params->set('access-edit', true);
			}
		}
		
		// Check edit state permission.
		if(!$itemId)
		{
			if (!empty($value->catId))
			{
				$asset = 'com_communitysurveys.category.' . $value->catId;
			}
			else
			{
				$asset = 'com_communitysurveys';
			}
		}
		
		// Existing item
		if($user->authorise('core.edit.state', $asset))
		{
			$value->params->set('access-change', true);
		}
		elseif (! empty($userId) && $user->authorise('core.edit.state.own', $asset))
		{
			if ($userId == $value->created_by)
			{
				$value->params->set('access-change', true);
			}
		}
		
		// Convert the metadata field to an array.
		$registry = new JRegistry();
		$registry->loadString($value->metadata);
		$value->metadata = $registry->toArray();
		
		if ($itemId)
		{
			$value->tags = new JHelperTags();
			$value->tags->getTagIds($value->id, 'com_communitysurveys.survey');
			$value->metadata['tags'] = $value->tags;
		}
		
		return $value;
	}

	public function getReturnPage ()
	{
		return base64_encode($this->getState('return_page'));
	}

	public function save ($data)
	{
		// Associations are not edited in frontend ATM so we have to inherit
		// them
		if (JLanguageAssociations::isEnabled() && ! empty($data['id']))
		{
			if ($associations = JLanguageAssociations::getAssociations('com_communitysurveys', '#__survey_surveys', 'com_communitysurveys.item', $data['id']))
			{
				foreach ($associations as $tag => $associated)
				{
					$associations[$tag] = (int) $associated->id;
				}
				
				$data['associations'] = $associations;
			}
		}
		
		return parent::save($data);
	}
}
