<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();
require_once JPATH_ADMINISTRATOR . '/components/com_communitysurveys/models/questionsbase.php';

class CommunitySurveysModelQuestions extends CommunitySurveysModelQuestionsBase
{
	public function __construct ($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
					'id', 'a.id',
					'survey_id', 'a.survey_id',
					'created_by', 'a.created_by',
					'sort_order', 'a.sort_order',
					'page_number', 'a.page_number'
			);
		}
		
		parent::__construct($config);
	}

	protected function populateState ($ordering = 'sort_order', $direction = 'ASC')
	{
		$app = JFactory::getApplication();
		$params = JComponentHelper::getParams('com_communitysurveys');
		
		// List state information
		$value = $app->input->get('limit', $params->get('questions_limit', 1), 'uint');
		$this->setState('list.limit', $value);
		
		$value = $app->input->get('limitstart', 0, 'uint');
		$this->setState('list.start', $value);
		
		$categories = $app->input->getArray(array('catid'=>'array'));
		$this->setState('filter.category_id', $categories['catid']);
		
		$questions = $app->input->getArray(array('qid'=>'array'));
		$this->setState('filter.question_id', $questions['qid']);
		
		$surveyId = $app->input->get('survey_id', 0, 'uint');
		if($surveyId)
		{
			$this->setState('filter.survey_id', $surveyId);
		}
		
		$pageId = $app->input->get('page_id', 0, 'uint');
		if($pageId)
		{
			$this->setState('filter.page_id', $pageId);
		}
		
		// Filtering for unique questions for category survey
		$filterUniq = $app->input->get('filter_unique', false, 'boolean');
		$this->setState('filter.unique', $filterUniq);
		
		$filterResponseId = $app->input->get('filter_response_id', 0, 'uint');
		$this->setState('filter.response_id', $filterResponseId);
		
		$orderCol = $app->input->get('filter_order', $params->get('questions_ordering', 'a.sort_order'));
		
		if (! in_array($orderCol, $this->filter_fields))
		{
			$orderCol = 'a.sort_order';
		}
		
		$this->setState('list.ordering', $orderCol);
		
		$listOrder = $app->input->get('filter_order_Dir', $params->get('questions_ordering_dir', 'DESC'));
		
		if (! in_array(strtoupper($listOrder), array('ASC', 'DESC', '')))
		{
			$listOrder = 'DESC';
		}
		
		$this->setState('list.direction', $listOrder);
		$this->setState('params', $params);
	}

	protected function getStoreId ($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.survey_id');
		$id .= ':' . $this->getState('filter.survey_id.include');
		$id .= ':' . $this->getState('filter.page_id');
		$id .= ':' . $this->getState('filter.page_id.include');
		$id .= ':' . $this->getState('filter.question_id.include');
		$id .= ':' . $this->getState('filter.category_id.include');
		
		return parent::getStoreId($id);
	}
}