<?php
/**
 * @package     corejoomla.site
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();
require_once JPATH_ADMINISTRATOR . '/components/com_communitysurveys/models/reports.php';

class CommunitySurveysModelResult extends CommunitySurveysModelReports
{
	protected function populateState ($ordering = NULL, $direction = NULL)
	{
		$app = JFactory::getApplication('site');
	
		// Load state from the request.
		$pk = $app->input->getInt('id');
		$this->setState($this->getName() . '.id', $pk);
		
		$responseId = $app->input->getInt('rid');
		$this->setState('filter.response_id', $responseId);

		$pageId = $app->input->getInt('pid');
		$this->setState('filter.page_id', $pageId);
		
		$questions = $app->input->getArray(array('qid'=>'array'));
		$this->setState('filter.question_id', $questions['qid']);
		
		$offset = $app->input->getUInt('limitstart');
		$this->setState('list.offset', $offset);
	
		// Load the parameters.
		$params = JComponentHelper::getParams('com_communitysurveys');
		$this->setState('params', $params);
	
		// TODO: Tune these values based on other permissions.
		$user = JFactory::getUser();
	
		if ((! $user->authorise('core.edit.state', 'com_communitysurveys')) && (! $user->authorise('core.edit', 'com_communitysurveys')))
		{
			$this->setState('filter.published', 1);
			$this->setState('filter.archived', 2);
		}
	
		$this->setState('filter.language', JLanguageMultilang::isEnabled());
	}
	
	protected $_error = '';

	function __construct ()
	{
		parent::__construct();
		$this->populateState();
	}

	public function getError ($i = null, $toString = true)
	{
		return $this->_error;
	}

	public function setError ($error)
	{
		$this->_error = $error;
	}

	public function isUserAuthorised($surveyId, $responseId, $surveyKey = null)
	{
		$db = JFactory::getDbo();
		$user = JFactory::getUser();
		if(($user->guest && empty($surveyKey)) || !$surveyId || !$responseId)
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR').'| RC=1', 403);
		}
		
		$query = $db->getQuery(true)
			->select('survey_id')
			->from('#__survey_responses')
			->where('id = '.$responseId.' and survey_id = '.$surveyId);
		
		if($surveyKey)
		{
			$query->where('(created_by = '.$user->id.' or survey_key = '.$db->q($surveyKey).')');
		}
		else 
		{
			$query->where('created_by = '.$user->id);
		}
		
		$db->setQuery($query);
		$surveyId = (int) $db->loadResult();
		
		return $surveyId ? true : false;
	}
}