<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

use Joomla\CMS\Component\Router\Rules\MenuRules;
use Joomla\CMS\Component\Router\Rules\StandardRules;
use Joomla\CMS\Component\Router\Rules\NomenuRules;

class CommunitySurveysRouter extends JComponentRouterView
{
    protected $noIDs = false;
    
    /**
     * Community Surveys Component router constructor
     *
     * @param   JApplicationCms  $app   The application object
     * @param   JMenu            $menu  The menu object to work with
     */
    public function __construct($app = null, $menu = null)
    {
        $params = JComponentHelper::getParams('com_communitysurveys');
        $this->noIDs = (bool) $params->get('sef_ids');
        
        $categories = new JComponentRouterViewconfiguration('categories');
        $categories->setKey('id');
        $this->registerView($categories);
        
        $category = new JComponentRouterViewconfiguration('category');
        $category->setKey('id')->setParent($categories, 'catid')->setNestable();
        $this->registerView($category);
        
        $topic = new JComponentRouterViewconfiguration('survey');
        $topic->setKey('id')->setParent($category, 'catid');
        $this->registerView($topic);
        
        $form = new JComponentRouterViewconfiguration('form');
        $form->setKey('s_id');
        $this->registerView($form);
        
        $this->registerView(new JComponentRouterViewconfiguration('surveys'));
        $this->registerView(new JComponentRouterViewconfiguration('mysurveys'));
        $this->registerView(new JComponentRouterViewconfiguration('myresponses'));
        $this->registerView(new JComponentRouterViewconfiguration('search'));
        
        parent::__construct($app, $menu);
        
        if (version_compare(JVERSION,'4','ge'))
        {
            $this->attachRule(new MenuRules($this));
            $this->attachRule(new StandardRules($this));
            $this->attachRule(new NomenuRules($this));
        }
        else
        {
            JLoader::register('CommunitySurveysRouterRulesLegacy', __DIR__ . '/helpers/legacyrouter.php');
            $this->attachRule(new CommunitySurveysRouterRulesLegacy($this));
        }
    }
    
    /**
     * Method to get the segment(s) for a category
     *
     * @param   string  $id     ID of the category to retrieve the segments for
     * @param   array   $query  The request that is build right now
     *
     * @return  array|string  The segments of this item
     */
    public function getCategorySegment($id, $query)
    {
        $category = JCategories::getInstance($this->getName())->get($id);
        if ($category)
        {
            $path = array_reverse($category->getPath(), true);
            $path[0] = '1:root';
            
            if ($this->noIDs)
            {
                foreach ($path as &$segment)
                {
                    list($id, $segment) = explode(':', $segment, 2);
                }
            }
            
            return $path;
        }
        
        return array();
    }
    
    /**
     * Method to get the segment(s) for categories
     *
     * @param   string  $id     ID of the category to retrieve the segments for
     * @param   array   $query  The request that is build right now
     *
     * @return  array|string  The segments of this item
     */
    public function getCategoriesSegment($id, $query)
    {
        return $this->getCategorySegment($id, $query);
    }
    
    /**
     * Method to get the segment(s) for an topic
     *
     * @param   string  $id     ID of the topic to retrieve the segments for
     * @param   array   $query  The request that is build right now
     *
     * @return  array|string  The segments of this item
     */
    public function getSurveySegment($id, $query)
    {
        if (!strpos($id, ':'))
        {
            $db = \JFactory::getDbo();
            $dbquery = $db->getQuery(true);
            $dbquery->select($dbquery->qn('alias'))
                ->from($dbquery->qn('#__survey_surveys'))
                ->where('id = ' . $dbquery->q((int) $id));
            $db->setQuery($dbquery);
            
            $id .= ':' . $db->loadResult();
        }
        
        if ($this->noIDs)
        {
            list($void, $segment) = explode(':', $id, 2);
            
            return array($void => $segment);
        }
        
        return array((int) $id => $id);
    }
    
    /**
     * Method to get the id for a category
     *
     * @param   string  $segment  Segment to retrieve the ID for
     * @param   array   $query    The request that is parsed right now
     *
     * @return  mixed   The id of this item or false
     */
    public function getCategoryId($segment, $query)
    {
        if (isset($query['id']))
        {
            $category = \JCategories::getInstance($this->getName(), array('access' => false))->get($query['id']);
            
            if ($category)
            {
                foreach ($category->getChildren() as $child)
                {
                    if ($this->noIDs)
                    {
                        if ($child->alias == $segment)
                        {
                            return $child->id;
                        }
                    }
                    else
                    {
                        if ($child->id == (int) $segment)
                        {
                            return $child->id;
                        }
                    }
                }
            }
        }
        
        return false;
    }
    
    /**
     * Method to get the segment(s) for a category
     *
     * @param   string  $segment  Segment to retrieve the ID for
     * @param   array   $query    The request that is parsed right now
     *
     * @return  mixed   The id of this item or false
     */
    public function getCategoriesId($segment, $query)
    {
        return $this->getCategoryId($segment, $query);
    }
    
    /**
     * Method to get the segment(s) for an topic
     *
     * @param   string  $segment  Segment of the topic to retrieve the ID for
     * @param   array   $query    The request that is parsed right now
     *
     * @return  mixed   The id of this item or false
     */
    public function getSurveyId($segment, $query)
    {
        if ($this->noIDs)
        {
            $db = \JFactory::getDbo();
            $dbquery = $db->getQuery(true);
            $dbquery->select($dbquery->qn('id'))
                ->from($dbquery->qn('#__survey_surveys'))
                ->where('alias = ' . $dbquery->q($segment))
                ->where('catid = ' . $dbquery->q($query['id']));
            $db->setQuery($dbquery);
            
            return (int) $db->loadResult();
        }
        
        return (int) $segment;
    }
}