<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

JHtml::_('behavior.tabstate');
JHtml::_('behavior.keepalive');
JHtml::_('behavior.calendar');
JHtml::_('behavior.formvalidator');
JHtml::_('formbehavior.chosen', 'select');

JFactory::getLanguage()->load('joomla', JPATH_ADMINISTRATOR);

// Create shortcut to parameters.
$params = $this->state->get('params');
$layout = $params->get('ui_layout', 'default');
$theme = $params->get('theme', 'default');

// This checks if the editor config options have ever been saved. If they haven't they will fall back to the original settings.
$editoroptions = isset($params->show_publishing_options);

$this->tab_name = 'com-communitysurveys-form';
?>

<script type="text/javascript">
	Joomla.submitbutton = function(task)
	{
		if (task == 'survey.cancel' || document.formvalidator.isValid(document.getElementById('adminForm')))
		{
			<?php echo $this->form->getField('description')->save(); ?>
			Joomla.submitform(task);
		}
	}
</script>
<div id="cj-wrapper" class="edit <?php echo $this->pageclass_sfx; ?>">
	
	<?php echo SurveyHelper::renderLayout($layout.'.toolbar', array('params'=>$params, 'state'=>$this->state));?>

	<?php if ($params->get('show_page_heading', 1)) : ?>
	<h3 class="page-header no-margin-top"><?php echo $this->escape($params->get('page_heading')); ?></h3>
	<?php endif; ?>

	<form action="<?php echo JRoute::_(CommunitySurveysHelperRoute::getFormRoute($this->item->id)); ?>" method="post" name="adminForm" id="adminForm" class="form-validate form-horizontal">
		<fieldset>
			<?php 
			echo JHtml::_('bootstrap.startTabSet', $this->tab_name, array('active' => 'setup'));
				echo JHtml::_('bootstrap.addTab', $this->tab_name, 'setup', JText::_('COM_COMMUNITYSURVEYS_SURVEY_SETUP'));
					echo $this->form->renderField('title');
					
					if (is_null($this->item->id) || $this->user->authorise('core.manage', 'com_communitysurveys.survey.'.$this->item->id))
					{
						echo $this->form->renderField('alias');
					}
					
					foreach ($this->form->getFieldset('survey_options') as $field) 
					{
						echo $this->form->renderField($field->fieldname);
					}
				echo JHtml::_('bootstrap.endTab'); 
				
				echo JHtml::_('bootstrap.addTab', $this->tab_name, 'survey-content', JText::_('COM_COMMUNITYSURVEYS_SURVEY_CONTENT'));
				    echo $this->form->renderField('description');
				    echo $this->form->renderField('endtext');
				    echo $this->form->renderField('custom_header');
			    echo JHtml::_('bootstrap.endTab');
			    
			    echo JHtml::_('bootstrap.addTab', $this->tab_name, 'attrib-basic', JText::_('COM_COMMUNITYSURVEYS_FIELDSET_SURVEY_OPTIONS'));
    			    foreach ($this->form->getFieldset('basic') as $field)
    			    {
    			        echo $field->renderField();
    			    }
			    echo JHtml::_('bootstrap.endTab');
			    
			    echo JHtml::_('bootstrap.addTab', $this->tab_name, 'attrib-options', JText::_('COM_COMMUNITYSURVEYS_FIELDSET_SURVEY_EXTENDED_OPTIONS'));
    			    foreach ($this->form->getFieldset('options') as $field)
    			    {
    			        echo $field->renderField();
    			    }
			    echo JHtml::_('bootstrap.endTab');
			    
			    echo JHtml::_('bootstrap.addTab', $this->tab_name, 'publishing', JText::_('COM_COMMUNITYSURVEYS_FIELDSET_PUBLISHING'));
    			    echo $this->form->renderField('publish_up');
    			    echo $this->form->renderField('publish_down');
    			    
    			    if ($this->item->params->get('access-change'))
    			    {
    			        echo $this->form->renderField('published');
    			        echo $this->form->renderField('featured');
    			    }
    			    
    			    echo $this->form->renderField('language');
    			    echo $this->form->renderField('access');
    			    echo $this->form->renderField('metadesc');
    			    echo $this->form->renderField('metakey');
			    echo JHtml::_('bootstrap.endTab');
			    
		    echo JHtml::_('bootstrap.endTabSet');
		    
		    echo JHtml::_('form.token');
            ?>				
			<input type="hidden" name="task" value="" />
			<input type="hidden" name="return" value="<?php echo base64_encode(CommunitySurveysHelperRoute::getSurveysRoute()); ?>" />
		</fieldset>
		
		<div class="panel panel-<?php echo $theme;?> card card-<?php echo $theme;?> mt-3 mb-3 margin-top-20">
			<div class="panel-body card-body text-center">
    			<div class="btn-group">
    				<button type="button" class="btn" onclick="Joomla.submitbutton('survey.cancel')">
    					<span class="icon-cancel"></span>&#160;<?php echo JText::_('JCANCEL') ?>
    				</button>
    			</div>
    			
    			<?php if($this->item->id):?>
    			<div class="btn-group">
    				<button type="button" class="btn btn-default" onclick="Joomla.submitbutton('survey.save2copy')">
    					<span class="icon-copy"></span>&#160;<?php echo JText::_('JTOOLBAR_SAVE_AS_COPY') ?>
    				</button>
    			</div>
    			<?php endif;?>
    			
    			<div class="btn-group">
    				<button type="button" class="btn btn-primary" onclick="Joomla.submitbutton('survey.save')">
    					<span class="icon-ok"></span>&#160;<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_SAVE_AND_NEXT') ?>
    				</button>
    			</div>
    		</div>
		</div>
	</form>
</div>