<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params = $this->state->get('params');
$layout = $params->get('ui_layout', 'default');
?>

<div id="cj-wrapper" class="p-4">
	<div class="alert alert-info margin-top-10">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		<i class="fa fa-info-circle"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_PREVIEW_QUESTIONS_HELP');?>
	</div>
	<?php 
	foreach ($this->pages as $i=>$page)
	{
		?>
		<h1 class="page-header">
			<?php echo !empty($page->title) ? $this->escape($page->title) : JText::sprintf('COM_COMMUNITYSURVEYS_PAGE_TITLE_LABEL', $i + 1);?>
		</h1>
		<?php 
		
		foreach ($this->questions as $question)
		{
		    if($question->page_number == $page->id)
		    {
		        echo SurveyHelper::renderLayout($layout.'.response.question', array('data'=>$this, 'question'=>$question));
		    }
		}
	}
	?>
</div>