<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

JHTML::_('behavior.tabstate');
JHTML::_('behavior.keepalive');
JHTML::_('behavior.calendar');
JHTML::_('behavior.formvalidator');
JHTML::_('formbehavior.chosen', 'select:not(.chosen-disabled)');
jimport('joomla.html.editor');

$params 	= $this->state->get('params');
$layout 	= $params->get('ui_layout', 'default');
?>

<div id="cj-wrapper">
	<?php echo SurveyHelper::renderLayout($layout.'.toolbar', array('params'=>$params, 'state'=>$this->state));?>
	
	<?php echo SurveyHelper::renderLayout($layout.'.form.questions', 
	    array('item'=>$this->item, 'questions'=>$this->questions, 'pages'=>$this->pages, 'pageId'=>$this->pid,'params'=>$params, 'state'=>$this->state));?>
	
	<form action="<?php echo JRoute::_('index.php?option=com_communitysurveys'); ?>" name="questionForm" id="questionForm" method="post">
		<input type="hidden" name="option" value="com_communitysurveys">
		<input type="hidden" name="view" value="question">
		<input type="hidden" name="task" value="question.add">
		<input type="hidden" name="survey_id" value="<?php echo $this->item->id;?>">
		<input type="hidden" name="pid" value="<?php echo $this->pid;?>">
		<input type="hidden" name="qtype" value="0">
		<input type="hidden" name="id" value="0">
		<input type="hidden" name="newpid" value="0">
	</form>
	
	<form id="file-upload-form" action="<?php echo JRoute::_('index.php?option=com_communitysurveys');?>" 
		enctype="multipart/form-data" method="post" style="position:absolute; top:-1000px;">
		<input type="file" name="input-attachment" id="input-file-upload">
		<input type="hidden" name="view" value="question">
		<input type="hidden" name="task" value="question.upload">
	</form>
	
	<div style="display: none;">
		<span id="msg-confirm-alert"><?php echo JText::_('COM_COMMUNITYSURVEYS_CONFIRM_ALERT');?></span>
		<div id="url_update_ordering"><?php echo JRoute::_('index.php?option=com_communitysurveys&task=question.reorder&format=json');?></div>
		<div id="progress-message"><h3><i class="fa fa-spinner fa-spin"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_PROGRESS_LOADING_MESSAGE');?></h3></div>
		<input type="hidden" name="cjpageid" id="cjpageid" value="questions_form">
		<input type="hidden" name="return" value="<?php echo $this->return_page; ?>" />
		<span id="textMoveQuestion"><?php echo JText::_('COM_COMMUNITYSURVEYS_MOVE_QUESTION_TEXT');?></span>
		<span id="textCopyQuestion"><?php echo JText::_('COM_COMMUNITYSURVEYS_COPY_QUESTION_TEXT');?></span>
		<span id="textPromptPageTitle"><?php echo JText::_('COM_COMMUNITYSURVEYS_ENTER_NEW_PAGE_TITLE');?></span>
	</div>
</div>