<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');
JFactory::getLanguage()->load('joomla', JPATH_ADMINISTRATOR);

$layout 	= $this->params->get('ui_layout');
$return     = base64_encode(JUri::getInstance());
$pagination	= $this->pagination;
?>
<div id="cj-wrapper" class="category-details<?php echo $this->pageclass_sfx;?>">
	<?php echo SurveyHelper::renderLayout($layout.'.toolbar', array('params'=>$this->params, 'state'=>$this->state));?>

	<div class="margin-bottom-10 clearfix">
		<?php if($this->params->get('allow_export_responses', 1)):?>
		<a class="btn btn-success btn-small btn-sm pull-right" href="<?php echo JRoute::_('index.php?option=com_communitysurveys&task=responses.export');?>" target="_blank">
			<i class="fa fa-download"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_EXPORT')?>
		</a>
		<?php endif;?>
		
		<h3 class="page-header no-space-top no-space-bottom"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_MY_RESPONSES')?></h3>
	</div>

	<form action="<?php echo JRoute::_('index.php');?>" method="post" name="adminForm" id="adminForm">
		
		<?php echo SurveyHelper::renderLayout($layout.'.responses_list', array('params'=>$this->params, 'items'=>$this->items));?>
		
		<?php 
		if (($this->params->def('show_pagination', 2) == 1  || ($this->params->get('show_pagination') == 2)) && ($pagination->pagesTotal > 1))
		{
			?>
			<div class="pagination">
				<?php if ($this->params->def('show_pagination_results', 1)) : ?>
					<p class="counter pull-right">
						<?php echo $pagination->getPagesCounter(); ?>
					</p>
				<?php endif; ?>
		
				<?php echo $pagination->getPagesLinks(); ?>
			</div>
			<?php 
	    }
		?>
		
		<input type="hidden" id="cjpageid" value="mysurveys">
		<input type="hidden" name="boxchecked" value="0">
		<input type="hidden" name="option" value="com_communitysurveys">
		<input type="hidden" name="view" value="mysurveys">
		<input type="hidden" name="task" value="">
		<input type="hidden" name="return" value="<?php echo $return;?>">
		<?php echo JHtml::_('form.token'); ?>
	</form>
</div>
