<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');
JFactory::getLanguage()->load('joomla', JPATH_ADMINISTRATOR);

$user		= JFactory::getUser();
$layout 	= $this->params->get('ui_layout');
$return     = base64_encode(JUri::getInstance());
$archived	= $this->state->get('filter.published') == 2 ? true : false;
$trashed	= $this->state->get('filter.published') == -2 ? true : false;
?>
<div id="cj-wrapper" class="category-details<?php echo $this->pageclass_sfx;?>">
	<?php echo SurveyHelper::renderLayout($layout.'.toolbar', array('params'=>$this->params, 'state'=>$this->state));?>
	
	<form action="<?php echo JRoute::_('index.php?option=com_communitysurveys');?>" method="post" name="adminForm" id="adminForm">
		<table class="table table-hover table-striped table-bordered">
			<thead>
				<tr>
					<th width="5%"><?php echo JText::_('ID');?></th>
					<th width="8%"><?php echo JText::_('JSTATUS');?></th>
					<th><?php echo JText::_('JGLOBAL_TITLE');?></th>
					<th width="10%"><?php echo JText::_('JGLOBAL_EDIT');?>
					<th width="10%"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_QUESTIONS');?></th>
					<th width="10%"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_REPORTS');?></th>
					<th width="10%"><?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE');?></th>
					<th width="20%"><?php echo JText::_('JDATE');?></th>
					<th width="5%"><?php echo JText::_('JGLOBAL_HITS');?></th>
				</tr>
			</thead>
			<tbody>
				<?php if(count($this->items)):?>
					<?php foreach ($this->items as $i=>$item):?>
					<tr>
						<td><?php echo JHtml::_('grid.id', $i, $item->id).' '.$item->id; ?></td>
						<td>
							<div class="btn-group">
								<?php echo JHtml::_('jgrid.published', $item->state, $i, 'surveys.', true, 'cb'); ?>
								<?php
								// Create dropdown items
								$action = $archived ? 'unarchive' : 'archive';
								JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'surveys');
			
								$action = $trashed ? 'untrash' : 'trash';
								JHtml::_('actionsdropdown.' . $action, 'cb' . $i, 'surveys');
			
								// Render dropdown list
								echo JHtml::_('actionsdropdown.render', $this->escape($item->title));
								?>
							</div>
						</td>
						<td><?php echo $this->escape($item->title);?></td>
						
						<td>
							<?php if($user->authorise('core.edit.own', 'com_communitysurveys.survey.'.$item->id)):?>
							<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getFormRoute($item->id));?>">
								<i class="fa fa-edit"></i> <?php echo JText::_('JGLOBAL_EDIT');?>
							</a>
							<?php endif;?>
						</td>
						<td>
							<?php if($user->authorise('core.edit.own', 'com_communitysurveys.survey.'.$item->id)):?>
							<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getFormRoute($item->id).'&layout=questions');?>">
								<i class="fa fa-edit"></i> <?php echo JText::_('JGLOBAL_EDIT');?>
							</a>
							<?php endif;?>
						</td>
						<td>
							<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getReportsRoute($item->id));?>">
								<i class="fa fa-bar-chart"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_VIEW');?>
							</a>
						</td>
						<td>
							<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getInviteRoute($item->id));?>">
								<i class="fa fa-envelope"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_INVITE');?>
							</a>
						</td>
						<td><?php echo JHtml::_('date', $item->created, JText::_('DATE_FORMAT_LC2')); ?></td>
						<td><?php echo $item->responses;?></td>
					</tr>
					<?php endforeach;?>
				<?php else :?>
				<tr>
					<td colspan="8">
						<div class="alert alert-info"><?php echo JText::_('COM_COMMUNITYSURVEYS_NO_SURVEYS');?></div>
					</td>
				</tr>
				<?php endif;?>
			</tbody>
		</table>
		
		<input type="hidden" id="cjpageid" value="mysurveys">
		<input type="hidden" name="boxchecked" value="0">
		<input type="hidden" name="option" value="com_communitysurveys">
		<input type="hidden" name="view" value="mysurveys">
		<input type="hidden" name="task" value="">
		<input type="hidden" name="return" value="<?php echo $return;?>">
		<?php echo JHtml::_('form.token'); ?>
	</form>
</div>
