<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

class CommunitySurveysViewReport extends JViewLegacy
{
	public $items;

	public $pagination;

	public $state;

	public function display($tpl = null)
	{
		$app          = JFactory::getApplication();
		$user         = JFactory::getUser();
		
		$this->item   = $this->get('Item');
		$this->print  = $app->input->getBool('print');
		$this->state  = $this->get('State');
		$this->params = $this->state->get('params');
		$this->layout = $this->getLayout();
		$this->name   = $this->get('name');
		
		if($this->item->created_by != $user->id && !$user->authorise('core.manage', 'com_communitysurveys.survey.'.$this->item->id))
		{
		    if($user->guest)
		    {
		        $redirectUrl = base64_encode(JUri::getInstance()->toString());
		        $loginUrl = JRoute::_('index.php?option=com_users&view=login&return='.$redirectUrl, false);
		        $app->redirect($loginUrl, JText::_('COM_COMMUNITYSURVEYS_ERROR_LOGIN_TO_EXECUTE'));
		    }
		    else
		    {
		        throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		    }
		}
		
		switch ($this->layout)
		{
			case 'responses':
				$return 				= $this->get('Responses');
				$this->responses		= &$return->responses;
				$this->questions		= &$return->questions;
				$this->pagination 		= &$return->pagination;
				$this->authors			= &$return->authors;
				$this->filterForm		= &$return->filterForm;
				$this->activeFilters	= &$return->activeFilters;
				$this->state			= &$return->state;
				$this->filter_rules     = &$return->filter_rules;
				
				$this->state->set('filter.survey_id', $this->item->id);
				break;
				
			case 'response':
				$model = $this->getModel();
				$this->rid = $app->input->getInt('rid', 0);
				$model->setState('response.id', $this->rid);
				$this->questions = $this->get('Response');
				break;
				
			case 'consolidated':
			    $data = $this->get('consolidatedReport');
			    $this->report = $data->questions;
			    $this->filter_rules = $data->filter_rules;
			    break;
				
			case 'locations':
				$this->report = $this->get('locationsReport');
				break;
				
			case 'browsers':
				$this->report = $this->get('browsersReport');
				break;
				
			case 'platforms':
				$this->report = $this->get('platformsReport');
				break;
				
			case 'default':
			default:
				$this->item->stats = $this->get('Stats');
				$this->layout = 'dashboard';
				break;
		}
		
		if($this->print)
		{
			$app->input->set('tmpl', 'component');
			$app->input->set('format', 'raw');
			JFactory::getDocument()->setMetaData('robots', 'noindex, nofollow');
		}

		parent::display($tpl);
	}
}