<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

$params  	= $this->params;
$layout 	= $params->get('ui_layout', 'default');

if($this->print)
{
	?>
	<script type="text/javascript">
	<!--
	window.print();
	//-->
	</script>
	<?php 
}
?>
<div class="cj-wrapper clearfix" id="cj-wrapper">

    <?php
    if(!$this->print)
    { 
        echo SurveyHelper::renderLayout($layout.'.toolbar', array('params'=>$this->params, 'state'=>$this->state));
        ?>
        <div class="print-toolbar">
        	<p>
        		<a class="btn btn-default" 
        			href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getResponseRoute($this->id, $this->rid).'&print=1'.(!empty($this->key) ? '&key='.$this->key : ''));?>" 
        			target="_blank">
        			<?php echo JText::_('JGLOBAL_PRINT');?>
        		</a>
        	</p>
        </div>
        <?php 
    }
    ?>
    <div class="survey-result<?php echo $this->print ? ' print-layout' : '';?>">
    	<?php 
    	foreach ($this->questions as $question)
    	{
    		$question->rid = $this->rid;
    		echo SurveyHelper::renderLayout($layout.'.results.question', array('item'=>$question, 'params'=>$params));
    	}
    	?>
    </div>

	<form name="surveyForm" id="surveyForm" action="<?php echo JRoute::_('index.php?option=com_communitysurveys')?>" method="post">
	   <input type="hidden" name="task" value="reports.getanswers" />
	   <input type="hidden" name="qid" value="" />
	   <input type="hidden" name="id" value="<?php echo $this->item->id;?>" />
	</form>
	
	<div style="display: none;">
		<div id="rating_hints"><?php echo JText::_('COM_COMMUNITYSURVEYS_RATING_HINTS_TEXT')?></div>
		<input type="hidden" id="cjpageid" value="reports">
	</div>
</div>