<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers');
JHtml::_('bootstrap.framework');
JHtml::_('formbehavior.chosen', 'select:not(.chosen-disabled)');

$layout = $this->item->params->get('ui_layout', 'default');
?>
<div id="cj-wrapper" class="survey-wrapper <?php echo !empty($this->pageclass_sfx) ? $this->pageclass_sfx : ''; ?>">
	<div class="<?php echo $this->hide_template ? 'full-screen ' : '';?>">
		<?php 
		if(!$this->hide_template)
		{
	        echo SurveyHelper::renderLayout($layout.'.toolbar', array('params'=>$this->item->params, 'state'=>$this->state));
	    }
	
	    if($this->params->get('enable_captcha', 0))
	    {
	    	JPluginHelper::importPlugin('captcha');
	    	JFactory::getApplication()->triggerEvent('onInit', array('cjsurvey_captcha'));
	    }
	    
	    echo SurveyHelper::renderLayout($layout.'.survey.survey_main', array('data'=>$this), '', array('debug'=>false));
	    ?>
	</div>
</div>
