<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

class CommunitySurveysViewSurvey extends JViewLegacy
{
	public function display($tpl = null)
	{
		$survey = $this->get('Item');
		
		if($survey && $survey->id)
		{
			JLoader::import('joomla.application.component.model');
			JLoader::import('questions', JPATH_ROOT.'/components/com_communitysurveys/models');
			
			$questionsModel	= JModelLegacy::getInstance( 'questions', 'CommunitySurveysModel' );
			$state = $questionsModel->getState(); // access the state first so that it can be modified
			$pages = $questionsModel->getPages($survey->id);
			$pid = 0;
			if(!empty($pages) && isset($pages[0]))
			{
			    $pid = $pages[0]->id;
			}
			
			$questionsModel->setState('filter.survey_id', $survey->id);
			$questionsModel->setState('filter.category_id', 0);
			$questionsModel->setState('filter.page_id', null);
			$questionsModel->setState('filter.question_id', null);
			$questionsModel->setState('list.ordering', 'a.sort_order');
			$questionsModel->setState('list.direction', 'asc');
			$questionsModel->setState('list.limit', 0);
			$questions = $questionsModel->getItems();
			
			$survey->questions = &$questions;
			$survey->pages = &$pages;
		}
		
		require_once CJLIB_PATH.'/framework/obj2xml.php';
		$xml = Object2Xml::generateValidXmlFromObj($survey, 'survey');
		echo $xml;
	}
}