<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

require_once JPATH_ROOT . '/components/com_cjlib/framework.php';
require_once JPATH_ROOT . '/components/com_communitysurveys/helpers/constants.php';
require_once JPATH_ROOT . '/components/com_communitysurveys/helpers/route.php';
require_once JPATH_ROOT . '/components/com_communitysurveys/helpers/query.php';
require_once JPATH_ROOT . '/components/com_communitysurveys/helpers/helper.php';
require_once JPATH_ROOT . '/components/com_communitysurveys/helpers/pagination.php';
require_once __DIR__ . '/helper.php';

// Initialize module parameters.
$surveyId 	= $params->get('survey_id', 0);
$appParams	= JComponentHelper::getParams('com_communitysurveys');
$loadCss 	= $appParams->get('load_bootstrap_css', false);
$custom_tag = $appParams->get('custom_tag', true);

CJLib::import('corejoomla.framework.core');
CjLib::behavior('bootstrap', array('loadcss' => $loadCss));

if($appParams->get('ui_layout', 'default') != 'bs3')
{
	CJLib::behavior('bscore', array('customtag'=>$custom_tag));
}

JHtml::_('bootstrap.framework');
JHtml::_('behavior.caption');
JHtml::_('formbehavior.chosen', 'select:not(.chosen-disabled)');

$document = JFactory::getDocument();
$document->addScript('https://www.google.com/jsapi');

$language = JFactory::getLanguage();
$language->load('com_communitysurveys');

CJFunctions::load_jquery(array('libs'=>array('fontawesome'), 'custom_tag'=>$custom_tag));
CJFunctions::add_script(CJLIB_MEDIA_URI.'/jquery/jquery.raty.js', $custom_tag);
CJFunctions::add_script(JUri::root(true).'/media/com_communitysurveys/js/cj.surveys.min.js', $custom_tag);
CJFunctions::add_css_to_document($document, JUri::root(true).'/media/com_communitysurveys/css/cj.surveys.min.css', $custom_tag);

$data = SurveyResultsHelper::getConsolidatedReport($params);

// Get Smart Search query object.
require JModuleHelper::getLayoutPath('mod_surveyresults', $params->get('ui_layout', 'default'));