<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  plg_content_surveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class PlgContentSurveys extends JPlugin
{
	public function __construct(& $subject, $config)
	{
		parent::__construct($subject, $config);
		
		require_once JPATH_ROOT.'/components/com_cjlib/framework.php';
		require_once JPATH_ROOT.'/components/com_cjlib/framework/api.php';
		require_once JPATH_ROOT.'/components/com_communitysurveys/router.php';
		require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/constants.php';
		require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/query.php';
		require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/route.php';
		require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/helper.php';
		require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/pagination.php';

		JModelLegacy::addIncludePath(JPATH_ROOT.'/components/com_communitysurveys/models');
		
		// Load language
		$language = JFactory::getLanguage();
		$language->load('com_communitysurveys', JPATH_ADMINISTRATOR);
		$language->load('com_communitysurveys');
	}
	
	public function onContentPrepare($context, &$article, &$params, $page = 0)
	{
		//Don't run this plugin when the content is being indexed
		if ($context == 'com_finder.indexer' || JFactory::getApplication()->isAdmin())
		{
			return true;
		}
	
		// simple performance check to determine whether bot should process further
		if (strpos($article->text, 'LOADSURVEY') === false && strpos($article->text, 'loadmodule') === false)
		{
			return true;
		}
		
		$app = JFactory::getApplication();
		$appParams	= JComponentHelper::getParams('com_communitysurveys');
		$loadCss 	= $appParams->get('load_bootstrap_css', false);
		$custom_tag = $appParams->get('custom_tag', true);
		
		CJLib::import('corejoomla.framework.core');
		CjLib::behavior('bootstrap', array('loadcss' => $loadCss));
		
		if($appParams->get('ui_layout', 'default') != 'bs3')
		{
			CJLib::behavior('bscore', array('customtag'=>$custom_tag));
		}
		
		JHtml::_('bootstrap.framework');
		JHtml::_('behavior.caption');
		JHtml::_('formbehavior.chosen', 'select:not(.chosen-disabled)');
		
		$document = JFactory::getDocument();
		JHtml::_('jquery.ui', array('core', 'sortable'));
		CjScript::_('datetime', array('custom'=>$custom_tag));
		CjScript::_('signaturepad', array('custom'=>$custom_tag));
		CjScript::_('slider', array('custom'=>$custom_tag));
		CjScript::_('noty', array('custom'=>$custom_tag));
		
		CJFunctions::load_jquery(array('libs'=>array('fontawesome', 'form', 'validate', 'blockui', 'message'), 'custom_tag'=>$custom_tag));
		CJFunctions::add_script(JUri::base(true).'/media/system/js/core.js', $custom_tag);
		CJFunctions::add_script(CJLIB_MEDIA_URI.'/jquery/jquery.plugin.min.js', $custom_tag);
		CJFunctions::add_script(CJLIB_MEDIA_URI.'/jquery/jquery.raty.js', $custom_tag);
		CJFunctions::add_script(JUri::base(true).'/media/com_cjlib/jquery/json2.js', $custom_tag);
		CJFunctions::add_script(JUri::base(true).'/media/com_communitysurveys/js/jquery.ui.touch-punch.min.js', $custom_tag);
		CJFunctions::add_script(JUri::root(true).'/media/com_communitysurveys/js/cj.surveys.min.js', $custom_tag);
		CJFunctions::add_css_to_document($document, JUri::root(true).'/media/com_communitysurveys/css/cj.surveys.min.css', $custom_tag);
		
		if($appParams->get('enable_captcha', 0))
		{
			JPluginHelper::importPlugin('captcha');
			$app->triggerEvent('onInit', array('cjsurvey_captcha'));
		}
		
		$plgParams = &$this->params;
		$article->text = preg_replace_callback('/\{LOADSURVEY(.*?)\}/', function($matches) use ($plgParams)
		{
			$content = '';
			$options = json_decode(str_replace(']', '}', str_replace('[', '{', trim($matches[1]))));
			$app = JFactory::getApplication();
			
			if(!$options || !$options->id)
			{
				return '';
			}
			
			if(empty($options->container))
			{
				$options->container = 'content-survey-'.rand(1000, 9999);
			}
		
			if(empty($options->template))
			{
				$options->template = 'default';
			}
			
			$user 				= JFactory::getUser();
			$model				= JModelLegacy::getInstance( 'survey', 'CommunitySurveysModel' );
			$item				= $model->getItem($options->id);
			
			$item->params->merge($plgParams);
			$layout 			= $item->params->get('ui_layout', 'default');

			// Create a shortcut for $item.
			$item->offset 		= $model->getState('list.offset');
			$item->tagLayout	= new JLayoutFile('joomla.content.tags');
			
			// Add router helpers.
			$item->slug 		= $item->alias ? ($item->id . ':' . $item->alias) : $item->id;
			$item->catslug 		= $item->category_alias ? ($item->catid . ':' . $item->category_alias) : $item->catid;
			$item->parent_slug 	= $item->parent_alias ? ($item->parent_id . ':' . $item->parent_alias) : $item->parent_id;
			
			// Process the content plugins for survey description
// 			JPluginHelper::importPlugin('content');
			$item->text = $item->description;
// 			$app->triggerEvent('onContentPrepare', array('com_communitysurveys.survey',	&$item,	&$item->params,	$item->offset));
// 			$item->description = $item->text;
			
			$item->event = new stdClass();
// 			$results = $app->triggerEvent('onContentAfterTitle', array('com_communitysurveys.survey', &$item, &$item->params, $item->offset));
			$item->event->afterDisplayTitle = '';//trim(implode("\n", $results));
			
// 			$results = $app->triggerEvent('onContentBeforeDisplay', array('com_communitysurveys.survey', &$item, &$item->params, $item->offset));
			$item->event->beforeDisplayContent = '';//trim(implode("\n", $results));
			
// 			$results = $app->triggerEvent('onContentAfterDisplay', array('com_communitysurveys.survey', &$item, &$item->params, $item->offset));
			$item->event->afterDisplayContent = '';//trim(implode("\n", $results));
			
			$return 			= new stdClass();
			$return->item		= &$item;
			$return->user		= $user;
			$return->api		= new CjLibApi();
			$return->asset		= 'com_communitysurveys.survey.'.$item->id;
			$return->state		= $model->getState();
			$return->pageId 	= 0;
			$return->pagination	= null;
			$return->response	= null;
			$return->print		= $app->input->getBool('print');
			$return->key		= $app->input->getCmd('key');
			$return->skey		= $app->input->getCmd('skey');
			$return->params		= JComponentHelper::getParams('com_communitysurveys');
			
			if( ! $item->params->get('show_intro', 1) )
			{
				$responseModel	= JModelLegacy::getInstance( 'response', 'CommunitySurveysModel' );
				$responseModel->getState();
				$responseModel->setState('filter.survey_id', $item->id);
				
				try 
				{
					$response 		= $responseModel->createOrUpdateResponse($item->id, true, true);
					$pagination 	= $responseModel->getPagination();
					$pageId 		= $pagination->getCurrPageId();
				
					if( !$pageId )
					{
						// start page, create or update response
						$response = $responseModel->createOrUpdateResponse($item->id);
						$app->setUserState('com_communitysurveys.response.'.$response->response_id, $response);
						$pageId = $pagination->getNextPageId();
					}
				
					$questionsModel	= JModelLegacy::getInstance( 'questions', 'CommunitySurveysModel' );
					$questionsModel->getState(); // access the state first so that it can be modified
				
					$questionsModel->setState('filter.survey_id', $item->id);
					$questionsModel->setState('filter.category_id', 0);
					$questionsModel->setState('filter.page_id', $pageId);
					$questionsModel->setState('filter.question_id', null);
					$questionsModel->setState('list.ordering', 'a.sort_order');
					$questionsModel->setState('list.direction', 'asc');
					$questionsModel->setState('list.limit', 0);
					$questions = $questionsModel->getItems();
				
					$return->questions 		= &$questions;
					$return->response 		= &$response;
					$return->pagination 	= &$pagination;
					$return->pageId 		= $pageId;
				}
				catch(Exception $e)
				{
					return '<div id="cj-wrapper" class="survey-wrapper '.$options->container.'"><div class="alert alert-error">'.$e->getMessage().'</div></div>';
				}
			}
			
			$item->params->set('show_cancel_button', false);
			$content = SurveyHelper::renderLayout($layout.'.survey.survey_main', array('data'=>$return));
		
			return '<div id="cj-wrapper" class="survey-wrapper '.$options->container.'">'.$content.'</div>';
		}, $article->text);
	}
}
