<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  mod_cscategories
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class SurveyFormHelper 
{
	public static function getSurveyData($modParams)
	{
		$return 		= new stdClass();
		$app 			= JFactory::getApplication();
		$user 			= JFactory::getUser();
		$surveyId		= $modParams->get('survey_id');
		
		if(!$surveyId)
		{
			$surveyKey		= $modParams->get('survey_key');
			$db 			= JFactory::getDbo();
			$query = $db->getQuery(true)
				->select('id')
				->from('#__survey_surveys')
				->where('survey_key = '.$db->q($surveyKey));
			
			$db->setQuery($query);
			$surveyId = (int) $db->loadResult();
			
			if(!$surveyId)
			{
				return false;
			}
		}
		
		JModelLegacy::addIncludePath(JPATH_ROOT.'/components/com_communitysurveys/models');
		
		$model				= JModelItem::getInstance( 'survey', 'CommunitySurveysModel' );
		$item				= $model->getItem($surveyId);
		$layout 			= $item->params->get('ui_layout', 'default');
		
		// set layout from app params as the module layout will be different
		$item->params->merge($modParams);
		$item->params->set('ui_layout', $layout);
		$item->params->set('show_cancel_button', false);
	
		// Create a shortcut for $item.
		$item->offset 		= $model->getState('list.offset');
		$item->tagLayout	= new JLayoutFile('joomla.content.tags');
	
		// Add router helpers.
		$item->slug 		= $item->alias ? ($item->id . ':' . $item->alias) : $item->id;
		$item->catslug 		= $item->category_alias ? ($item->catid . ':' . $item->category_alias) : $item->catid;
		$item->parent_slug 	= $item->parent_alias ? ($item->parent_id . ':' . $item->parent_alias) : $item->parent_id;
	
		// Process the content plugins for survey description
		JPluginHelper::importPlugin('content');
		$item->text = $item->description;
		$app->triggerEvent('onContentPrepare', array('com_communitysurveys.survey',	&$item,	&$item->params,	$item->offset));
		$item->description = $item->text;
	
		$item->event = new stdClass();
		$results = $app->triggerEvent('onContentAfterTitle', array('com_communitysurveys.survey', &$item, &$item->params, $item->offset));
		$item->event->afterDisplayTitle = trim(implode("\n", $results));
	
		$results = $app->triggerEvent('onContentBeforeDisplay', array('com_communitysurveys.survey', &$item, &$item->params, $item->offset));
		$item->event->beforeDisplayContent = trim(implode("\n", $results));
	
		$results = $app->triggerEvent('onContentAfterDisplay', array('com_communitysurveys.survey', &$item, &$item->params, $item->offset));
		$item->event->afterDisplayContent = trim(implode("\n", $results));
	
		$return->item		= &$item;
		$return->user		= $user;
		$return->api		= new CjLibApi();
		$return->asset		= 'com_communitysurveys.survey.'.$item->id;
		$return->state		= $model->getState();
		$return->pageId 	= 0;
		$return->pagination	= null;
		$return->response	= null;
		$return->print		= $app->input->getBool('print');
		$return->key		= $app->input->getCmd('key');
		$return->skey		= $app->input->getCmd('skey');
		$return->params		= $item->params;
	
		if( ! $item->params->get('show_intro', 1))
		{
			$responseModel	= JModelLegacy::getInstance( 'response', 'CommunitySurveysModel' );
			$responseModel->getState();
			$responseModel->setState('filter.survey_id', $item->id);
			
			try 
			{
				$response 		= $responseModel->createOrUpdateResponse($item->id, true, true);
				$pagination 	= $responseModel->getPagination();
				$pageId 		= $pagination->getCurrPageId();
	
				if( !$pageId )
				{
					// start page, create or update response
					$app->setUserState('com_communitysurveys.response.'.$response->response_id, $response);
					$pageId = $pagination->getNextPageId();
				}
		
				$questionsModel	= JModelLegacy::getInstance( 'questions', 'CommunitySurveysModel' );
				$questionsModel->getState(); // access the state first so that it can be modified
		
				$questionsModel->setState('filter.survey_id', $item->id);
				$questionsModel->setState('filter.category_id', 0);
				$questionsModel->setState('filter.page_id', $pageId);
				$questionsModel->setState('filter.question_id', null);
				$questionsModel->setState('list.ordering', 'a.sort_order');
				$questionsModel->setState('list.direction', 'asc');
				$questionsModel->setState('list.limit', 0);
				$questions = $questionsModel->getItems();
	
				$return->questions 		= &$questions;
				$return->response 		= &$response;
				$return->pagination 	= &$pagination;
				$return->pageId 		= $pageId;
			}
			catch (Exception $e)
			{
				$return->error = $e->getMessage();
			}
		}
	
		return $return;
	}
}