<?php
/**
 * @version		$Id: helper.php 01 2011-22-08 11:37:09Z maverick $
 * @package		CoreJoomla.Surveys
 * @subpackage	Modules.site
 * @copyright	Copyright (C) 2009 - 2019 corejoomla.com, Inc. All rights reserved.
 * @author		Maverick
 * @link		http://www.corejoomla.com/
 * @license		License GNU General Public License version 2 or later
 */
defined('_JEXEC') or die;

class modCommunitySurveysHelper
{
	public static function getLatestSurveys($params) 
	{
		return modCommunitySurveysHelper::getSurveys(1, $params);
	}

	public static function getMostPopularSurveys($params) 
	{
		return modCommunitySurveysHelper::getSurveys(2, $params);
	}

	private static function getSurveys($action=1, $params) 
	{
		$catid = $params->get('category', null);
		$catid = Joomla\Utilities\ArrayHelper::toInteger($catid);
		
		$ordering = $action == 1 ? 'a.created' : 'a.responses';
		$limit = intval($params->get('count', 5));
		
		JLoader::import('surveys', JPATH_ROOT.'/components/com_communitysurveys/models');
		$model = JModelLegacy::getInstance( 'Surveys', 'CommunitySurveysModel' );
		$state = $model->getState();
		
		$appParams = JComponentHelper::getParams('com_communitysurveys');
		$model->setState('params', $appParams);
		$model->setState('filter.category_id', $catid);
		$model->setState('filter.published', 1);
		$model->setState('list.ordering', $ordering);
		$model->setState('list.direction', 'desc');
		$model->setState('list.start', 0);
		$model->setState('list.limit', $limit);
		
		$rows = $model->getItems();
		return $rows;
	}
} //end
