<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  mod_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

// include the helper file
require_once(dirname(__FILE__).'/helper.php');
require_once(JPATH_SITE.'/components/com_communitysurveys/router.php');
require_once(JPATH_SITE.'/components/com_communitysurveys/helpers/constants.php');
require_once(JPATH_SITE.'/components/com_communitysurveys/helpers/helper.php');
require_once(JPATH_SITE.'/components/com_communitysurveys/helpers/route.php');
require_once(JPATH_SITE.'/components/com_communitysurveys/helpers/query.php');

// CJLib includes
require_once JPATH_ROOT.'/components/com_cjlib/framework.php';
CJLib::import('corejoomla.framework.core');

// Get the properties
$show_latest = intval($params->get('show_latest','1'));
$show_popular = intval($params->get('show_most_popular','1'));
$show_tabs = intval($params->get('show_tabs','1'));
$tab_order = trim($params->get('tab_order', 'L,M'));

// Get the item id for community answers
$document = JFactory::getDocument();
$document->addStyleSheet(JURI::base(true).'/modules/mod_communitysurveys/assets/communitysurveys.css');

// get the items to display from the helper
$order = explode(',', $tab_order);

if($show_tabs == 1){

	CJLib::import('corejoomla.ui.bootstrap', true);

	echo  '<div id="cj-wrapper">';
	echo  '<ul class="nav nav-tabs" data-tabs="tabs">';

	foreach ($order as $i=>$tab){

		if((strcmp($tab, "L") == 0) && $show_latest){
			
			echo '<li'.($i == 0 ? ' class="active"' : '').'><a href="#cstab-1" data-toggle="tab">'.JText::_('LBL_LATEST_SURVEYS').'</a></li>';
		}

		if((strcmp($tab, 'M') == 0) && $show_popular){
			
			echo '<li'.($i == 0 ? ' class="active"' : '').'><a href="#cstab-2" data-toggle="tab">'.JText::_('LBL_MOST_POPULAR_SURVEYS').'</a></li>';
		}
	}

	echo '</ul>';

	foreach ($order as $i=>$tab){

		if((strcmp($tab,'L') == 0) && $show_latest){
				
			$latest_surveys = modCommunitySurveysHelper::getLatestSurveys($params);
				
			echo '<div id="cstab-1" class="tab-pane fade'.($i == 0 ? ' in active' : '').'">';
			require(JModuleHelper::getLayoutPath('mod_communitysurveys','latest_surveys'));
			echo '</div>';
		}

		if((strcmp($tab,'M') == 0) && $show_popular){
				
			$popular_surveys = modCommunitySurveysHelper::getMostPopularSurveys($params);
				
			echo '<div id="cstab-2" class="tab-pane fade'.($i == 0 ? ' in active' : '').'">';
			require(JModuleHelper::getLayoutPath('mod_communitysurveys','most_popular'));
			echo '</div>';
		}
	}

	echo '</div>';
}else{

	foreach ($order as $tab){

		if((strcmp($tab,'L') == 0) && $show_latest){
				
			$latest_surveys = modCommunitySurveysHelper::getLatestSurveys($params);
			require(JModuleHelper::getLayoutPath('mod_communitysurveys','latest_surveys'));
		}

		if((strcmp($tab,'M') == 0) && $show_popular){
				
			$popular_surveys = modCommunitySurveysHelper::getMostPopularSurveys($params);
			require(JModuleHelper::getLayoutPath('mod_communitysurveys','most_popular'));
		}
	}
}
?>
