<?php
/**
 * @package     corejoomla.site
 * @subpackage  mod_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

if ( $latest_surveys ) {
?>
<table border="0" cellpadding="5" cellspacing="0" width="100%" class="sectiontable<?php echo $params->get( 'pageclass_sfx' ); ?>">
	<?php if ( $params->get('showheader') ) { ?>
	<thead>
		<tr class="header">
			<?php if ( $params->get('showleaderboard') ) { ?>
			<th class="sectiontableheader<?php echo $params->get( 'pageclass_sfx' ); ?>" width="25px">
				<div align="center">#</div>
			</th>
			<?php } ?>
	
			<th class="sectiontableheader<?php echo $params->get( 'pageclass_sfx' ); ?>">
				<div align="left"><?php echo JText::_('LBL_TITLE'); ?></div>
			</th>
	
			<?php if ( $params->get('showauthor') ) { ?>
			<th class="sectiontableheader<?php echo $params->get( 'pageclass_sfx' ); ?>" width="20%">
				<div align="left"><?php echo JText::_('LBL_AUTHOR'); ?></div>
			</th>
			<?php } ?>
	
			<?php if ( $params->get('showresponses') ) { ?>
			<th class="sectiontableheader<?php echo $params->get( 'pageclass_sfx' ); ?>" width="50px">
				<div align="left"><?php echo JText::_('LBL_RESPONSES'); ?></div>
			</th>
			<?php } ?>
		</tr>
	</thead>
	<?php } ?>
	<tbody>
		<?php
		$i = 1;
		$k = 0;
		foreach ($latest_surveys as $item) {
		$href = JRoute::_( CommunitySurveysHelperRoute::getSurveyRoute($item->id, $item->catid, $item->language));
		?>
		<tr class="<?php echo $k?'noalt':'alt'; ?>">
			<?php if ( $params->get('showleaderboard') ) { ?>
			<td class="sectiontableentry<?php echo $k; ?>">
				<div align="center"><?php echo $i; ?></div>
			</td>
			<?php } ?>
			
			<td align="left"><a href="<?php echo $href; ?>"> <?php echo CjLibUtils::escape($item->title); ?></a></td>
			
			<?php if ( $params->get('showauthor') ) { ?>
			<td align="left"><?php echo CjLibUtils::escape($item->author); ?></td>
			<?php } ?>
			
			<?php if ( $params->get('showresponses') ) { ?>
			<td align="center"><?php echo $item->responses; ?></td>
			<?php } ?>
		</tr>
		<?php
		$i++;
		$k = 1 - $k;
		}
		?>
	</tbody>
</table>
<?php
}
?>