<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  plg_acymailing_surveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

require_once JPATH_ROOT.'/components/com_cjlib/framework.php';
require_once JPATH_ROOT.'/components/com_cjlib/framework/api.php';
require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/constants.php';
require_once JPATH_ROOT.'/components/com_communitysurveys/router.php';
require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/route.php';
require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/helper.php';

class plgAcymailingSurveys extends JPlugin
{
	public function __construct(& $subject, $config)
	{
		parent::__construct($subject, $config);

		if(!isset($this->params))
		{
			$plugin = JPluginHelper::getPlugin('acymailing', 'surveys');
			$this->params = new JParameter( $plugin->params );
		}
	}

	function acymailing_getPluginType() 
	{
		$onePlugin = new stdClass();
		$onePlugin->name = 'Community Surveys';
		$onePlugin->function = 'surveys_show';

		return $onePlugin;
	}

	function surveys_show()
	{
		$db = JFactory::getDbo();
		$app = JFactory::getApplication();
		
		$limitstart = $app->getUserStateFromRequest( 'com_communitysurveys.acysurveys.limitstart', 'limitstart', 0, 'int' );
		$limit = $app->input->getInt('limit', 20);
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);
		
		$content = '';
		$paramBase = 'com_communitysurveys.acysurveys';
		$pageInfo = new stdClass();
		$pageInfo->filter->order = $pageInfo->filter = new stdClass();
		
		$pageInfo->filter->order->value = $app->getUserStateFromRequest( $paramBase.".filter_order", 'filter_order',	'a.id','cmd' );
		$pageInfo->filter->order->dir	= $app->getUserStateFromRequest( $paramBase.".filter_order_Dir", 'filter_order_Dir',	'desc',	'word' );
		$pageInfo->search = $app->getUserStateFromRequest( $paramBase.".search", 'search', '', 'string' );
		$pageInfo->search = \Joomla\String\StringHelper::strtolower( $pageInfo->search );
		
		$query = '
				select 
					a.id, a.title, a.alias, a.created_by, a.created, u.name, u.username
				from
					#__survey_surveys a
				left join
					#__users u on a.created_by = u.id
				where
					a.published = 1
				order by
					a.created desc';
		
		$db->setQuery($query, $limitstart, $limit);
		$surveys = $db->loadObjectList();
		
		if(!empty($surveys))
		{
			$query = 'select count(*) from #__survey_surveys a where a.published = 1';
			
			jimport('joomla.html.pagination');
			$db->setQuery($query);
			$total = $db->loadResult();
			
			$pagination = new JPagination( $total, $limitstart, $limit );

			$content = '
						<table class="adminlist table table-striped table-hover" cellpadding="1" width="100%">
							<thead>
								<tr>
									<th class="title">'.JHTML::_('grid.sort', JText::_( 'FIELD_TITLE'), 'a.title', $pageInfo->filter->order->dir, $pageInfo->filter->order->value ).'</th>
									<th class="title">'.JHTML::_('grid.sort', JText::_( 'ACY_AUTHOR'), 'b.name', $pageInfo->filter->order->dir, $pageInfo->filter->order->value ).'</th>
									<th class="title">'.JHTML::_('grid.sort',   JText::_( 'ACY_CREATED' ), 'a.created', $pageInfo->filter->order->dir, $pageInfo->filter->order->value ).'</th>
									<th class="title titleid">'.JHTML::_('grid.sort',   JText::_( 'ACY_ID' ), 'a.id', $pageInfo->filter->order->dir, $pageInfo->filter->order->value ).'</th>
								</tr>
							</thead>
							<tfoot>
								<tr>
									<td colspan="5">'.$pagination->getListFooter().$pagination->getResultsCounter().'</td>
								</tr>
							</tfoot>
							<tbody>';
			
			foreach ($surveys as $row)
			{
				$k = 0;
				$content .= '<tr><td>';
				$text = '<b>'.JText::_('JOOMEXT_ALIAS').': </b>'.$row->alias;
				$content .= '<a href="#" onclick="setTag(\'{surveyurl:'.$row->id.'}\');insertTag();">'.acymailing_tooltip($text, $row->title, '', $row->title).'</a>';
				$content .= '</td><td>';
				
				$text = '<b>'.JText::_('JOOMEXT_NAME').' : </b>'.$row->name;
				$text .= '<br/><b>'.JText::_('ACY_USERNAME').' : </b>'.$row->username;
				$text .= '<br/><b>'.JText::_('ACY_ID').' : </b>'.$row->created_by;
				$content .= acymailing_tooltip($text, $row->name, '', $row->name);
				$content .= '</td>
							<td align="center">'.JHTML::_('date',  $row->created, JText::_('DATE_FORMAT_LC4') ).'</td>
							<td align="center">'.$row->id.'</td></tr>';
				$k = 1-$k;
			}
		
			$content .= '</tbody></table>
					<input type="hidden" name="boxchecked" value="0" />
					<input type="hidden" name="filter_order" value="" />
					<input type="hidden" name="filter_order_Dir" value="" />';
		}
		
		echo $content;
	}

	function acymailing_replaceusertags(&$email, &$user, $send = true)
	{
		if(!$send) return;
		
		$match = '#{surveyurl:(.*)}#Ui';
		$variables = array('body','altbody');
		$found = false;
		$results = array();
		
		foreach($variables as $var)
		{
			if(empty($email->$var)) continue;
			$found = preg_match_all($match,$email->$var,$results[$var]) || $found;
			if(empty($results[$var][0])) unset($results[$var]);
		}
		
		if(!$found) return;
		require_once JPATH_ROOT.'/components/com_cjlib/framework.php';
		CJLib::import('corejoomla.framework.core');
		
		$htmlreplace = array();
		$textreplace = array();
		$db = JFactory::getDbo();
		$mailerHelper = acymailing_get('helper.mailer');
		
		// load survey urls
		JLoader::import('response', JPATH_ROOT.'/components/com_communitysurveys/models');
		$responseModel = JModelLegacy::getInstance( 'response', 'CommunitySurveysModel' );
		
		foreach($results as $var => $allresults)
		{
			foreach($allresults[0] as $i => $oneTag)
			{
				if(isset($htmlreplace[$oneTag])) continue;

				$start = strpos($oneTag, ':') + 1;
				$length = strpos($oneTag, '}') - strpos($oneTag, ':') - 1;
				$sid = intval(substr($oneTag, $start, $length));
				
				if($sid > 0)
				{
					$invitee = new stdClass();
					$invitee->id = $user->userid;
					$users = array($invitee);
					$responseModel->createSurveyKeys($sid, 1, true, true, $users);
					$link = '<a href="'.$users[0]->url.'">'.$users[0]->url.'</a>';
					
					$htmlreplace[$oneTag] = $link;
					$textreplace[$oneTag] = $mailerHelper->textVersion($link);
				}
			}
		}
		
		$email->body = str_replace(array_keys($htmlreplace),$htmlreplace,$email->body);
		$email->altbody = str_replace(array_keys($textreplace),$textreplace,$email->altbody);
	}
}//endclass