<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  mod_surveyresults
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class SurveyResultsHelper 
{
	public static function getConsolidatedReport($modParams)
	{
		$surveyId = $modParams->get('survey_id');
		if(!$surveyId)
		{
			return false;
		}
		
		JModelLegacy::addIncludePath(JPATH_ROOT.'/components/com_communitysurveys/models');
		JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_communitysurveys/tables');

		$model			= JModelLegacy::getInstance( 'report', 'CommunitySurveysModel' );
		$consolidated   = $model->getConsolidatedReport($surveyId);
		$item			= $model->getItem($surveyId);
		
		$item->params	= JComponentHelper::getParams('com_communitysurveys');
		$layout 		= $item->params->get('ui_layout', 'default');
		
		$item->slug 	= isset($item->alias) ? ($item->id . ':' . $item->alias) : $item->id;
		$item->catslug 	= isset($item->category_alias) ? ($item->catid . ':' . $item->category_alias) : $item->catid;
		$item->text     = $item->description;
		
		// set layout from app params as the module layout will be different
		$item->params->merge($modParams);
		$item->params->set('ui_layout', $layout);
		$item->params->set('show_text_answers', false);
		$item->params->set('show_filter', false);
		
		$data 			= new stdClass();
		$data->item 	= &$item;
		$data->params	= &$item->params;
		$data->state	= $model->getState();
		$data->report 	= $consolidated->questions;
		$data->filter_rules = $consolidated->filter_rules;
		$data->api		= new CjLibApi();
		$data->user		= JFactory::getUser();
		$data->asset	= 'com_communitysurveys.survey.'.$item->id;
		$data->print     = false;
		
		return $data;
	}
}