<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  mod_cscategories
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

require_once JPATH_ROOT . '/components/com_cjlib/framework.php';
require_once JPATH_SITE . '/components/com_communitysurveys/helpers/route.php';
require_once JPATH_ROOT . '/modules/mod_cscategories/helper.php';

CJLib::import('corejoomla.framework.core');
jimport('joomla.application.categories');
CJFunctions::load_jquery(array('libs' => array('treeview')));

$app = JFactory::getApplication();
$categories = JCategories::getInstance('CommunitySurveys', array('countItems' => true, 'assetid' => 'cscategories'));

if (is_object($categories))
{
	$root = intval($params->get('catid', 0));
	$excluded = trim($params->get('excluded', ''));
	$excluded = explode(',', $excluded);
	$excluded = ArrayHelper::toInteger($excluded);
	
	$nodes = $categories->get($root);
	$script = '';
	
	if ($nodes)
	{
		$nodes = $nodes->getChildren(false);
		$catid = $app->input->getInt('cacatid', 0);
		$appname = $app->input->getCmd('option', '');
		
		if ($catid > 0 && ($appname == 'com_communitysurveys'))
		{
			$script = '
				jQuery(".cscategories").find("li[rel=\'' . $catid . '\']").find(".expandable-hitarea:first").click();
				jQuery(".cscategories").find("li[rel=\'' . $catid . '\']").parents("li.expandable").find(".expandable-hitarea:first").click();
				jQuery(".cscategories").find("li[rel=\'' . $catid . '\']").find("a:first").css("font-weight", "bold");';
		}
		
		JFactory::getDocument()->addScriptDeclaration('jQuery(document).ready(function($){
		        jQuery(".cscategories").find(".cat-list:first").treeview({"collapsed": true});' . $script . 'jQuery(".cscategories").show();});');
		
		echo '<div class="cscategories" style="display: none;">' . CsCategoriesHelper::get_tree_list($nodes, $excluded) . '</div>';
	}
}