<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

require_once JPATH_ROOT.'/components/com_cjlib/framework/api.php';
require_once JPATH_ROOT.'/components/com_communitysurveys/router.php';
require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/route.php';

class PlgCommunitysurveysSurveys extends JPlugin
{
	public function __construct(& $subject, $config)
	{
		parent::__construct($subject, $config);
		$this->loadLanguage();
		$this->loadLanguage('com_communitysurveys', JPATH_ROOT);
	}
	
	public function onSurveyBeforeSave($context, $survey, $isNew)
	{
		return true;
	}

	public function onResponseBeforeSave($context, $response, $isNew)
	{
		return true;
	}

	public function onSurveyBeforeDelete($context, $data)
	{
		return true;
	}

	public function onResponseBeforeDelete($context, $data)
	{
		return true;
	}
	
	public function onSurveyChangeState($context, $pks, $value)
	{
		return true;
	}

	public function onResponseChangeState($context, $pks, $value)
	{
		return true;
	}
	
	public function onSurveyAfterSave($context, $survey, $isNew)
	{
		if ($context != 'com_communitysurveys.form' || ! $isNew || $survey->published != 1)
		{
			return true;
		}
		
		$myparams = $this->params;
		
		if($myparams->get('points_new_survey', true))
		{
			$this->awardPoints($survey, 1);
		}
		
		if($myparams->get('activity_new_survey', true))
		{
			$this->streamActivity($survey, 1);
		}
		
		if($myparams->get('email_new_survey_admin', true) || $myparams->get('email_new_survey', true))
		{
			$this->sendEmail($survey, 1, $myparams);
		}
	}

	public function onResponseAfterSave($context, $survey, $isNew)
	{
		if ($context != 'com_communitysurveys.response' || ! $isNew || ! $survey || $survey->published != 1)
		{
			return true;
		}
	
		$myparams = $this->params;
		
		if($myparams->get('points_new_response', true))
		{
			$this->awardPoints($survey, 2);
		}
		
		if($myparams->get('activity_new_response', true))
		{
			$this->streamActivity($survey, 2);
		}

		if( $survey->params->get('send_notifications') || $myparams->get('email_new_response', true) || $myparams->get('email_new_response_admin', true) )
		{
			$this->sendEmail($survey, 2, $myparams);
		}
		
		if( $myparams->get('email_thankyou', true) && $survey->params->get('send_notifications') )
		{
			$this->sendEmail($survey, 3, $myparams);
		}
	}
	
	public function onSurveyAfterDelete($context, $survey)
	{
		if ($context != 'com_communitysurveys.survey' || empty($survey))
		{
			return true;
		}
		
		$myparams = $this->params;
		if($myparams->get('activity_new_survey', true))
		{
			$this->deleteActivity(1, $survey);
		}
	}
	
	public function onResponseAfterDelete($context, $response)
	{
		if ($context != 'com_communitysurveys.response' || empty($response))
		{
			return true;
		}
			
		$myparams = $this->params;
		if($myparams->get('activity_new_response', true))
		{
			$this->deleteActivity(2, $response);
		}
	}
	
	private function sendEmail($item, $type, $myparams)
	{
		$db = JFactory::getDbo();
		$survey = null;
		$surveyId = $item->id;
		$emailType = null;
		
		switch ($type)
		{
			case 1: // new survey
				$emailType = 'com_communitysurveys.new_survey';
				break;
				
			case 2: // new response
				$emailType = 'com_communitysurveys.new_response';
				break;
				
			case 3: // thank you
				$emailType = 'com_communitysurveys.thankyou';
				break;
		}
		
		$query = $db->getQuery(true)
			->select('a.id, a.title, a.alias, a.catid, a.description, a.created_by, a.attribs')
			->select('c.title as category_title, c.alias as category_alias')
			->select('u.name AS author, u.email as author_email')
			->from('#__survey_surveys AS a')
			->join('left', '#__categories AS c ON a.catid = c.id')
			->join('left', '#__users AS u on a.created_by = u.id')
			->where('a.id = '.$surveyId);
		$db->setQuery($query);
		
		try 
		{
			$survey = $db->loadObject();
		}
		catch (Exception $e)
		{
			return false;
		}
		
		if($survey)
		{
			$template = null;
			$tag = JFactory::getLanguage()->getTag();
			
			$query = $db->getQuery(true)
				->select('title, description, language')
				->from('#__survey_email_templates')
				->where('email_type = '.$db->q($emailType))
				->where('language in ('.$db->q($tag).','.$db->q('*').')')
				->where('published = 1');
			
			$db->setQuery($query);
			$templates = $db->loadObjectList('language');
			
			if(isset($templates[$tag]))
			{
				$template = $templates[$tag];
			}
			else if(isset($templates['*']))
			{
				$template = $templates['*'];
			}
			
			if(!empty($template))
			{
				JLoader::import('mail', JPATH_ROOT.'/components/com_communitysurveys/models');
				
				$user				= JFactory::getUser();
				$app                = JFactory::getApplication();
				$message 			= new stdClass();
				$mailModel			= JModelLegacy::getInstance( 'mail', 'CommunitySurveysModel' );
				$recipients			= array();
				$params 			= JComponentHelper::getParams('com_communitysurveys');
				$userDisplayName	= $params->get('user_display_name', 'name');
				$surveyUrl			= '';
				
				$survey->slug 	= $survey->alias ? ($survey->id . ':' . $survey->alias) : $survey->id;
				$survey->catslug 	= !empty($survey->category_alias) ? ($survey->catid . ':' . $survey->category_alias) : $survey->catid;
				
				$registry = new JRegistry();
				$registry->loadString($survey->attribs);
				$params->merge($registry);
				
				switch ($type)
				{
					case 1: // new survey, mails should go to admins
					    $message->asset_id = $survey->id;
					    $surveyUrl = JRoute::_(CommunitySurveysHelperRoute::getSurveyRoute($survey->slug, $survey->catslug), false, -1);
					    
					    if ($app->isClient('administrator'))
					    {
					        $surveyUrl = str_replace('/administrator/', '/', $surveyUrl);
					    }
					    
					    if($myparams->get('email_new_survey_admin', true) && $myparams->get('new_survey_admin_group'))
					    {
    					    $adminGroup = $myparams->get('new_survey_admin_group');
					        $recipients = $this->getGroupUsers($adminGroup);
					    }
					    
					    if($myparams->get('email_new_survey', true) && !empty($myparams->get('new_survey_email_ids')))
					    {
					        $emails = json_decode(json_encode($myparams->get('new_survey_email_ids')), true);
					        foreach ($emails as $email)
					        {
					            $author = new stdClass();
					            $author->name = $email['name'];
					            $author->email = $email['email'];
					            $recipients[] = $author;
					        }
					    }
						break;

					case 2: // new response, mails should go to author
					    $message->asset_id = $item->response_id;
					    $responseUri = CommunitySurveysHelperRoute::getReportsRoute($survey->id) . '&layout=response&rid='.$item->response_id;
					    $surveyUrl = JRoute::_($responseUri, false, $app->get('force_ssl') == 2 ? 1 : -1);

					    // Admin user group
					    if($myparams->get('email_new_response_admin', true) && $myparams->get('new_response_admin_group'))
					    {
					        $adminGroup = $myparams->get('new_response_admin_group');
					        $recipients = $this->getGroupUsers($adminGroup);
					    }

					    // Any custom email ids in the plugin options
					    if($myparams->get('email_new_response', true) && !empty($myparams->get('new_response_email_ids')))
					    {
					        $emails = json_decode(json_encode($myparams->get('new_response_email_ids')), true);
					        foreach ($emails as $email)
					        {
					            $author = new stdClass();
					            $author->name = $email['name'];
					            $author->email = $email['email'];
					            $recipients[] = $author;
					        }
					    }

					    // Any custom email ids mentioned in the survey options.
					    if($params->get('send_notifications'))
					    {
					        // Survey Author
					        $author = new stdClass();
					        $author->name = $survey->author;
					        $author->email = $survey->author_email;
					        $recipients[] = $author;
					        
					        if(!empty($params->get('notif_email_ids')))
					        {
        					    $emails = $params->get('notif_email_ids');
        					    if(!empty($emails))
        					    {
        					        foreach ($emails as $email)
        					        {
        					            $author = new stdClass();
        					            $author->name = $email['name'];
        					            $author->email = $email['email'];
        					            $recipients[] = $author;
        					        }
        					    }
					        }
					    }

					    // Attachments
					    $filename = '/media/com_communitysurveys/attachments/responses/'.$survey->id.'_'.$item->response_id.'.pdf';
					    if($params->get('attach_pdf_report', false) && file_exists(JPATH_ROOT.$filename))
					    {
					    	$message->params = array('attachment' => $filename);
					    }

					    break;
					    
					case 3: // thank you should go to responder
						$author = new stdClass();
						if($user->guest)
						{
						    $query = $db->getQuery(true)
						      ->select('a.id, a.question_type, r.free_text')
						      ->from('#__survey_questions AS a')
						      ->join('left', '#__survey_response_details AS r ON r.response_id = '.$item->response_id.' AND a.id = r.question_id')
						      ->where('survey_id = ' . $surveyId)
						      ->where('question_type IN ('.CS_SPECIAL_NAME  . ',' . CS_SPECIAL_EMAIL .')');
						    $db->setQuery($query);
						    $questions = $db->loadObjectList();
						    
						    if(empty($questions))
						    {
						        return;
						    }
						    
						    foreach ($questions as $question)
						    {
						        if($question->question_type == CS_SPECIAL_EMAIL)
						        {
						            $author->email = trim($question->free_text);
						        }
						        
						        if($question->question_type == CS_SPECIAL_NAME)
						        {
						            $author->name = str_replace('|', ' ', trim($question->free_text));
						            if(empty($author->name))
						            {
						                $author->name = JText::_('COM_COMMUNITYSURVEYS_GUEST');
						            }
						        }
						    }
						    
						    $regex = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$";
						    $modifiers = null;
						    
						    if (!defined('JCOMPAT_UNICODE_PROPERTIES'))
						    {
						        define('JCOMPAT_UNICODE_PROPERTIES', (bool) @preg_match('/\pL/u', 'a'));
						    }
						    
						    if (JCOMPAT_UNICODE_PROPERTIES)
						    {
						        $modifiers = (strpos($modifiers, 'u') !== false) ? $modifiers : $modifiers . 'u';
						    }
						    
						    if(empty($author->email) || !preg_match(chr(1) . $regex . chr(1) . $modifiers, $author->email))
						    {
						        return;
						    }
						}
						else 
						{
    						$author->name = $user->name;
    						$author->email = $user->email;
						}
						
						$recipients[] = $author;
						break;
				}

				$subject			= str_ireplace('{SURVEY_TITLE}', $survey->title, $template->title);
				$description 		= str_ireplace('{SITENAME}', $app->get('sitename'), $template->description);
				$description 		= str_ireplace('{SURVEY_TITLE}', $survey->title, $description);
				$description 		= str_ireplace('{SURVEY_URL}', $surveyUrl, $description);
				$description 		= str_ireplace('{CATEGORY}', $survey->category_title, $description);
				$description        = str_ireplace('{AUTHOR_NAME}', $user->$userDisplayName, $description);
				
				if(!empty($recipients) && !empty($message))
				{
					$message->asset_name 	= $emailType;
					$message->subject 		= $subject;
					$message->description 	= $description;
					
					$mailModel->enqueueMail($message, $recipients, 'none');
				}
			}
		}
		
		return true;
	}
	
	private function streamActivity($item, $type)
	{
		$params = JComponentHelper::getParams('com_communitysurveys');
		$streamApp = $params->get('stream_component', 'none');
		
		// Activity stream
		if(empty($streamApp) || $streamApp == 'none')
		{
			return true;
		}
		
		$db = JFactory::getDbo();
		$survey = null;
		
		$query = $db->getQuery(true)
			->select('a.id, a.title, a.alias, a.catid, a.description')
			->select('c.alias as category_alias')
			->select('u.name AS author')
			->from('#__survey_surveys AS a')
			->join('left', '#__categories AS c ON a.catid = c.id')
			->join('left', '#__users AS u on a.created_by = u.id')
			->where('a.id = '.$item->id);
		$db->setQuery($query);
		
		try 
		{
			$survey = $db->loadObject();
		}
		catch (Exception $e)
		{
			return false;
		}
		
		if($survey)
		{
			$user = JFactory::getUser();
			$language = JFactory::getLanguage();
			$language->load('com_communitysurveys');
			$api = new CjLibApi();
				
			$survey->slug = $survey->alias ? ($survey->id . ':' . $survey->alias) : $survey->id;
			$survey->catslug = !empty($survey->category_alias) ? ($survey->catid . ':' . $survey->category_alias) : $survey->catid;
			
			$profileComponent = $params->get('profile_component', 'none');
			$userName = $api->getUserProfileUrl($profileComponent, $user->id, false, $user->name);
			$surveyUrl = JRoute::_(CommunitySurveysHelperRoute::getSurveyRoute($survey->slug, $survey->catslug));
			$surveyUrl = str_replace('/administrator/', '/', $surveyUrl);
			$surveyLink = JHtml::link($surveyUrl, JComponentHelper::filterText($survey->title));
			$parentId = 0;
			$itemId = $survey->id;
			
			switch ($type)
			{
				case 1: // new survey
					$title = JText::sprintf('COM_COMMUNITYSURVEYS_ACTIVITY_NEW_SURVEY', $userName, $surveyLink);
					$description = $survey->description;
					$function = 'com_communitysurveys.new_survey';
					break;
			
				case 2: // survey reply
					$title = JText::sprintf('COM_COMMUNITYSURVEYS_ACTIVITY_NEW_RESPONSE', $userName, $surveyLink);
					$description = $item->description;
					$function = 'com_communitysurveys.new_response';
					$parentId = $survey->id;
					$itemId = $item->response_id;
					break;
			}
				
			$activity = new stdClass();
			$activity->type = $function;
			$activity->href = $surveyUrl;
			$activity->title = $title;
			$activity->description = $description;
			$activity->userId = $user->id;
			$activity->featured = 0;
			$activity->language = $language->getTag();
			$activity->itemId = $itemId;
			$activity->parentId = $parentId;
			$activity->length = $params->get('readmore_limit', 0);

			$api->pushActivity($streamApp, $activity);
		}
		
		return true;
	}
	

	private function deleteActivity($type, $item)
	{
		$params = JComponentHelper::getParams('com_communitysurveys');
		$streamApp = $params->get('stream_component', 'none');
		$api = new CjLibApi();
	
		// Activity stream
		if(empty($streamApp) || $streamApp == 'none')
		{
			return true;
		}
		
		switch ($type)
		{
			case 1: // new survey
				$itemId = $item->id;
				$function = 'com_communitysurveys.new_survey';
				break;
		
			case 2: // new reply
				$itemId = $item->id;
				$function = 'com_communitysurveys.new_response';
				break;
		}
		
		$activity = new stdClass();
		$activity->id = $itemId;
		$activity->type = $function;
		
		$api->deleteActivity($streamApp, $activity);
	}

	private function assignBadge($item, $type)
	{
        $params = JComponentHelper::getParams('com_communitysurveys');
        $badgeApp = $params->get('badge_system', 'none');
        if($badgeApp != 'cjblog' || !file_exists(JPATH_ROOT.'/components/com_cjblog/api.php'))
        {
            return true;
        }
        
	    $user = JFactory::getUser();
	    $db = JFactory::getDbo();
	    $survey = null;
	
	    $query = $db->getQuery(true)
    	    ->select('a.id, a.title, a.alias, a.catid, a.description, a.created_by, a.language')
    	    ->select('c.alias as category_alias')
    	    ->select('u.name AS author')
    	    ->from('#__survey_surveys AS a')
    	    ->join('left', '#__categories AS c ON a.catid = c.id')
    	    ->join('left', '#__users AS u on a.created_by = u.id')
    	    ->where('a.id = '.$item->id);
	    $db->setQuery($query);
	
	    try
	    {
	        $survey = $db->loadObject();
	    }
	    catch (Exception $e)
	    {
	        return false;
	    }
	
	    if($survey)
	    {
	        require_once JPATH_ROOT.'/components/com_cjblog/api.php';
	        $params = JComponentHelper::getParams('com_communitysurveys');
	        $badgeApp = $params->get('badge_system', 'none');
	        $numResponses = 0;
	        
            $query = $db->getQuery(true)
                ->select('count(*)')
                ->from('#__survey_responses')
                ->where('created_by = '.$user->id);
            
            $db->setQuery($query);
            try 
            {
                $numResponses = (int) $db->loadResult();

                // trigger badges rule for awarding for posting n number of responses
                CjBlogApi::trigger_badge_rule('com_communitysurveys.num_responses', array('num_responses'=>$numResponses, 'ref_id'=>$user->id.'.'.$numResponses), $user->id);
            }
            catch (Exception $e)
            {
                //continue;
            }
	    }
	}
	
	private function awardPoints($item, $type)
	{
		$user = JFactory::getUser();
		$api = new CjLibApi();
		
		$db = JFactory::getDbo();
		$survey = null;
		
		$query = $db->getQuery(true)
			->select('a.id, a.title, a.alias, a.catid, a.description, a.created_by, a.language, a.attribs')
			->select('c.alias as category_alias')
			->select('u.name AS author')
			->from('#__survey_surveys AS a')
			->join('left', '#__categories AS c ON a.catid = c.id')
			->join('left', '#__users AS u on a.created_by = u.id')
			->where('a.id = '.$item->id);
		$db->setQuery($query);
		
		try
		{
			$survey = $db->loadObject();
		}
		catch (Exception $e)
		{
			return false;
		}
		
		if($survey)
		{
			$params = JComponentHelper::getParams('com_communitysurveys');
			$pointsComponent = $params->get('points_component', 'none');
			
			$registry = new JRegistry();
			$registry->loadString($survey->attribs);
			$params->merge($registry);
			
			$survey->slug = $survey->alias ? ($survey->id . ':' . $survey->alias) : $survey->id;
			$survey->catslug = $survey->category_alias ? ($survey->catid . ':' . $survey->category_alias) : $survey->catid;
			$surveyUrl = JRoute::_(CommunitySurveysHelperRoute::getSurveyRoute($survey->slug, $survey->catslug, $survey->language), false);
			$surveyLink = JHtml::link($surveyUrl, JComponentHelper::filterText($survey->title));
			$info = '';
			$reference = $survey->id;
			$awardedTo = $user->id;
			
			switch ($type)
			{
				case 1: // new survey
					$function = 'com_communitysurveys.new_survey';
					$title = JText::sprintf('COM_COMMUNITYSURVEYS_POINTS_NEW_SURVEY', $surveyLink);
					$info = $survey->description; 
					break;
			
				case 2: // new response
					$function = 'com_communitysurveys.new_response';
					$title = JText::sprintf('COM_COMMUNITYSURVEYS_POINTS_NEW_RESPONSE', $surveyLink);
					$info = $item->description;
					$reference = $survey->id;
					break;
			}
			
			$options = array(
					'function'=>$function, 
					'points' => $params->get('points', 0), 
					'reference'=>$reference, 
					'info'=>$info, 
					'component'=>'com_communitysurveys', 
					'title'=>$title);
			$api->awardPoints($pointsComponent, $awardedTo, $options);
		}
		
		return true;
	}
	
	public function getGroupUsers($groupId)
	{
		if(!$groupId) 
		{
		    return false;
		}
		
		$userids = JAccess::getUsersByGroup($groupId);
		if(empty($userids)) 
		{
		    return false;
		}
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true)
		  ->select('name, email, 0 as subid')
		  ->from('#__users')
		  ->where('id in ('.implode(',', $userids).') and block = 0');
		
		$db->setQuery($query);
		$users = $db->loadObjectList();
	
		return $users;
	}
}