<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  plg_editor_survey
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class plgButtonSurveys extends JPlugin
{
	protected $autoloadLanguage = true;
	
    public function onDisplay($name)
    {
    	$js = "
		function jSelectSurvey(editor, id)
		{
            var tag = '<div>{LOADSURVEY [\"id\": '+id+']}</div>';

            if (window.parent.Joomla && window.parent.Joomla.editors && window.parent.Joomla.editors.instances && window.parent.Joomla.editors.instances.hasOwnProperty(editor)) {
                window.parent.Joomla.editors.instances[editor].replaceSelection(tag)
            } else {
                window.parent.jInsertEditorText(tag, editor);
            }

			window.parent.jModalClose();
		}";
    	
    	$doc = JFactory::getDocument();
    	$doc->addScriptDeclaration($js);
    	
    	JHtml::_('behavior.modal');
    	$link = 'index.php?option=com_communitysurveys&amp;view=surveys&amp;layout=modal&amp;tmpl=component&amp;function=jSelectSurvey&editor='.$name.'&amp;' . JSession::getFormToken() . '=1';

		$button = new JObject;
		$button->modal = true;
		$button->class = 'btn btn-default';
		$button->link = $link;
		$button->text = 'Survey';
		$button->name = 'file-add';
		$button->options = "{handler: 'iframe', size: {x: 800, y: 500}}";

        return $button;
    }
}
