<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysControllerInviteBase extends JControllerAdmin
{
	protected $text_prefix = 'COM_COMMUNITYSURVEYS';
	protected $base_path = CS_LAYOUTS_BASE_PATH;
	
	public function __construct ($config = array())
	{
		parent::__construct($config);
	}
	
	public function execute ($task)
	{
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		
		try
		{
			if($user->guest)
			{
				echo new JResponseJson(JText::_('COM_COMMUNITYSURVEYS_ERROR_LOGIN_TO_EXECUTE'), 403);
			}
			else 
			{
				switch ($task)
				{
					case 'usergroups':
						$this->inviteUserGroups();
						break;
						
					case 'users':
						$this->inviteRegisteredUsers();
						break;
						
					case 'contactgroups':
						$this->inviteContactGroups();
						break;
						
					case 'community':
						$this->inviteCommunityGroups();
						break;
						
					case 'savegroup':
						$this->saveContactGroup();
						break;
						
					case 'deletegroup':
						$this->deleteContactGroup();
						break;
						
					case 'savecontacts':
						$this->saveContacts();
						break;
						
					case 'deletecontacts':
						$this->deleteContacts();
						break;
						
					case 'importcontacts':
						$this->importContacts();
						break;
						
					case 'assigncontacts':
						$this->assignContacts();
						break;
						
					case 'getcontacts':
						$this->loadContacts();
						break;
						
					case 'getusers':
						$this->getRegisteredUsers();
						break;
						
					case 'createurls':
						$this->createUniqueSurveyUrls();
						break;
						
					case 'exporturls':
					    $this->exportUniqueSurveyUrls();
					    break;
				}
			}
		}
		catch (Exception $e)
		{
			echo new JResponseJson($e);
		}
	
		$app->close();
	}

	public function getModel ($name = 'Invite', $prefix = 'CommunitySurveysModel', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}
	
	protected function inviteUserGroups()
	{
		$user 	= JFactory::getUser();
		if(!$user->authorise('core.manage', 'com_communitysurveys'))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=1', 500);
		}
		
		$model = $this->getModel();
		$sent = $model->inviteUserGroups();
		echo new JResponseJson(1, JText::plural('COM_COMMUNITYSURVEYS_N_INVITATIONS_ADDED_TO_QUEUE', $sent));
	}

	protected function inviteRegisteredUsers()
	{
		$user 	= JFactory::getUser();
		if(!$user->authorise('core.manage', 'com_communitysurveys'))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=1', 500);
		}
		
		$model = $this->getModel();
		$sent = $model->inviteRegisteredUsers();
		echo new JResponseJson(1, JText::plural('COM_COMMUNITYSURVEYS_N_INVITATIONS_ADDED_TO_QUEUE', $sent));
	}

	protected function inviteContactGroups()
	{
		$model = $this->getModel();
		$sent = $model->inviteContactGroups();
		echo new JResponseJson(1, JText::plural('COM_COMMUNITYSURVEYS_N_INVITATIONS_ADDED_TO_QUEUE', $sent));
	}
	
	protected function inviteCommunityGroups()
	{
		$model = $this->getModel();
		$sent = $model->inviteCommunityGroups();
		echo new JResponseJson(1, JText::plural('COM_COMMUNITYSURVEYS_N_INVITATIONS_ADDED_TO_QUEUE', $sent));
	}
	
	protected function saveContactGroup()
	{
		$app 	= JFactory::getApplication();
		$model = $this->getModel();
		if(!$model->saveContactGroup())
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED'));
		}
		
		$params = JComponentHelper::getParams('com_communitysurveys');
		if($app->isAdmin())
		{
			$params->set('ui_layout', 'default');
		}
		$data			= new stdClass();
		$layout 		= $params->get('ui_layout', 'default');
		$data->cgroups	= $model->getContactGroups();
		
		$html = SurveyHelper::renderLayout($layout.'.invite.contactgroups.groupslist', array('data'=>$data));
		echo new JResponseJson($html);
	}
	
	protected function deleteContactGroup()
	{
		$app 	= JFactory::getApplication();
		$model = $this->getModel();
		if(!$model->deleteContactGroup())
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED'));
		}
		
		$params = JComponentHelper::getParams('com_communitysurveys');
		if($app->isAdmin())
		{
			$params->set('ui_layout', 'default');
		}
		$data			= new stdClass();
		$layout 		= $params->get('ui_layout', 'default');
		$data->cgroups	= $model->getContactGroups();
		
		$html = SurveyHelper::renderLayout($layout.'.invite.contactgroups.groupslist', array('data'=>$data));
		echo new JResponseJson($html);
	}
	
	protected function saveContacts()
	{
		$app 	= JFactory::getApplication();
		$model = $this->getModel();
		if(!$model->saveContacts())
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED'));
		}
		
		$params = JComponentHelper::getParams('com_communitysurveys');
		if($app->isAdmin())
		{
			$params->set('ui_layout', 'default');
		}
		$data				= new stdClass();
		$layout 			= $params->get('ui_layout', 'default');
		$data->contacts		= $model->getContacts();
		$data->pagination	= $model->getPagination();
		
		$html = SurveyHelper::renderLayout($layout.'.invite.contactgroups.contactslist', array('data'=>$data));
		echo new JResponseJson($html);
	}
	
	protected function deleteContacts()
	{
		$app 	= JFactory::getApplication();
		$model = $this->getModel();
		if(!$model->deleteContacts())
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED'));
		}
		
		$params = JComponentHelper::getParams('com_communitysurveys');
		if($app->isAdmin())
		{
			$params->set('ui_layout', 'default');
		}
		$data				= new stdClass();
		$layout 			= $params->get('ui_layout', 'default');
		$data->contacts		= $model->getContacts();
		$data->pagination	= $model->getPagination();
		
		$html = SurveyHelper::renderLayout($layout.'.invite.contactgroups.contactslist', array('data'=>$data));
		echo new JResponseJson($html);
	}

	protected function assignContacts()
	{
		$app		= JFactory::getApplication();
		$model 		= $this->getModel();
		$params 	= JComponentHelper::getParams('com_communitysurveys');
		$assigned 	= $model->assignContacts();
	
		if($app->isAdmin())
		{
			$params->set('ui_layout', 'default');
		}
	
		$data			= new stdClass();
		$layout 		= $params->get('ui_layout', 'default');
		$data->cgroups	= $model->getContactGroups();
		
		$postdata		= $app->input->post->get('jform', array(), 'array');
		$message = JText::plural('COM_COMMUNITYSURVEYS_N_CONTACTS_ASSIGNED', $assigned);
		if( empty($postdata['assignAction']) )
		{
			$message = JText::plural('COM_COMMUNITYSURVEYS_N_CONTACTS_UNASSIGNED', $assigned);
		}
	
		$html = SurveyHelper::renderLayout($layout.'.invite.contactgroups.groupslist', array('data'=>$data));
		echo new JResponseJson($html, $message);
	}
	
	protected function importContacts()
	{
		$input = JFactory::getApplication()->input;
		$tmp_file = $input->files->get('csvfile');
		if($tmp_file['error'] > 0)
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=1', 500);
		}
		else
		{
			$temp_file_path = $tmp_file['tmp_name'];
			$temp_file_name = $tmp_file['name'];
			$temp_file_ext = JFile::getExt($temp_file_name);
			if (!in_array(strtolower($temp_file_ext), array('csv', 'txt')))
			{
				throw new Exception(JText::_('COM_COMMUNITYSURVEYS_ERROR_INVALID_FILE'), 403);
			}
			
			$model = $this->getModel();
			if($model->importContacts($temp_file_path))
			{
				$app 	= JFactory::getApplication();
				$params = JComponentHelper::getParams('com_communitysurveys');
				if($app->isAdmin())
				{
					$params->set('ui_layout', 'default');
				}
				$data				= new stdClass();
				$layout 			= $params->get('ui_layout', 'default');
				$data->contacts		= $model->getContacts();
				$data->pagination	= $model->getPagination();
				
				$html = SurveyHelper::renderLayout($layout.'.invite.contactgroups.contactslist', array('data'=>$data));
				echo new JResponseJson($html);
			}
			else
			{
				throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=2', 500);
			}
		}
	}
	
	protected function loadContacts()
	{
		$app 	= JFactory::getApplication();
		$model 	= $this->getModel();
		$params = JComponentHelper::getParams('com_communitysurveys');
		
		if($app->isAdmin())
		{
			$params->set('ui_layout', 'default');
		}
		$data				= new stdClass();
		$layout 			= $params->get('ui_layout', 'default');
		$data->contacts		= $model->getContacts();
		$data->pagination	= $model->getPagination();
		
		$html = SurveyHelper::renderLayout($layout.'.invite.contactgroups.contactslist', array('data'=>$data));
		echo new JResponseJson($html);
	}

	protected function getRegisteredUsers()
	{
		$user	= JFactory::getUser();
		if(!$user->authorise('core.manage', 'com_communitysurveys'))
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=1', 500);
		}
		
		$app 	= JFactory::getApplication();
		$model 	= $this->getModel();
		$params = JComponentHelper::getParams('com_communitysurveys');
		
		if($app->isAdmin())
		{
			$params->set('ui_layout', 'default');
		}
		
		$users = $model->getRegisteredUsers();
		echo new JResponseJson($users);
	}
	
	public function createUniqueSurveyUrls()
	{
		$app 	= JFactory::getApplication();
		$model 	= $this->getModel();
		$params = JComponentHelper::getParams('com_communitysurveys');
		
		if($app->isAdmin())
		{
			$params->set('ui_layout', 'default');
		}
		
		$data	= new stdClass();
		$layout = $params->get('ui_layout', 'default');
		
		if($model->createUniqueUrls())
		{
			$data = new stdClass();
			$data->item = $model->getItem();
			$data->keys = $model->getKeys();
			
			$html = SurveyHelper::renderLayout($layout.'.invite.uniqueurls', array('data'=>$data));
			echo new JResponseJson($html);
		}
		else 
		{
			throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED') . '| RC=1', 500);
		}
	}
	
	public function exportUniqueSurveyUrls()
	{
	    $model = $this->getModel();
	    $surveyId = $this->input->getInt('id', 0);
	    $data = $model->getUniqueUrlsList($surveyId);
	    
	    $now = gmdate("D, d M Y H:i:s");
	    header("Expires: Tue, 03 Jul 2001 06:00:00 GMT");
	    header("Cache-Control: max-age=0, no-cache, must-revalidate, proxy-revalidate");
	    header("Last-Modified: {$now} GMT");
	    
	    header("Content-Type: application/force-download");
	    header("Content-Type: application/octet-stream");
	    header("Content-Type: application/download");
	    header("Content-Disposition: attachment; filename=unique_urls_" .$surveyId . ".csv");
	    header("Content-Transfer-Encoding: binary");
	    
	    ob_start();
	    $df = fopen("php://output", 'w');
	    foreach ($data as $row)
	    {
	        fputcsv($df, $row);
	    }
	    
	    fclose($df);
	    echo ob_get_clean();
	    
	    jexit();
	}
}