<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysControllerLanguage extends JControllerForm
{
	public function __construct($config = array())
	{
		parent::__construct($config);
	}
	
	/**
	 * Gets the URL arguments to append to an item redirect.
	 *
	 * @param   integer  $recordId  The primary key id for the item.
	 * @param   string   $urlVar    The name of the URL variable for the id.
	 *
	 * @return  string  The arguments to append to the redirect URL.
	 */
	protected function getRedirectToItemAppend($recordId = null, $urlVar = 'id')
	{
	    $append = parent::getRedirectToItemAppend($recordId, $urlVar);
	    
	    // Setup redirect info.
	    if ($surveyId = $this->input->get('survey_id', 0, 'int'))
	    {
	        $append .= '&survey_id=' . $surveyId;
	    }
	    
	    return $append;
	}
	
	/**
	 * Gets the URL arguments to append to a list redirect.
	 *
	 * @return  string  The arguments to append to the redirect URL.
	 */
	protected function getRedirectToListAppend()
	{
	    $append = parent::getRedirectToListAppend();
	    
	    // Setup redirect info.
	    if ($surveyId = $this->input->get('survey_id', 0, 'int'))
	    {
	        $append .= '&survey_id=' . $surveyId;
	    }
	    
	    return $append;
	}
}
