<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class CommunitySurveysControllerMigrate extends JControllerAdmin
{
	protected $text_prefix = 'COM_COMMUNITYSURVEYS';
	
	public function __construct ($config = array())
	{
		parent::__construct($config);
	}

	public function execute ($task)
	{
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		
		if(!$user->authorise('core.admin', 'com_communitysurveys'))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		$items = $app->input->getWord('items', 'surveys');
		
		try
		{
			switch ($items)
			{
				case 'surveys':
					$this->migrateSurveys(10);
					break;
					
				default:
					throw new Exception('Invalid option', 403);
			}
		}
		catch(Exception $e)
		{
			echo new JResponseJson($e);
		}
	}
	
	private function migrateSurveys($increment = 10)
	{
		$app = JFactory::getApplication();
		$model = $this->getModel();
		
		$startId = $app->input->getInt('startId', 0);
		$endId = $app->input->getInt('endId', 0);
		$lastId = $app->input->getInt('lastId', 0);
		
		if($startId == 0 && $endId == 0)
		{
			$result = $model->getFirstAndLastQuestionId();
			
			if(empty($result->min_id) || empty($result->max_id))
			{
				throw new Exception(JText::_('JERROR_AN_ERROR_HAS_OCCURRED'), 500);
			}
			
			echo new JResponseJson($result, "<i class='fa fa-spinner fa-spin'></i> Syncing data now. This may take some time depending on the amount of data present.");
		}
		else if(($endId <= $lastId + $increment) && $model->migrateSurveys($startId, $endId))
		{
			echo new JResponseJson(-1, "<i class='fa fa-spinner fa-spin'></i> Syncing data now. This may take some time depending on the amount of data present.");
		}
		else 
		{
// 			$model->doFinalSteps();
			throw new Exception('Successfully completed.');
		}
	}

	public function getModel ($name = 'Migrate', $prefix = 'CommunitySurveysModel', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);
		return $model;
	}
}