<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysControllerResponse extends JControllerLegacy 
{
    function __construct()
	{
	    parent::__construct();
	    $this->registerTask('downloadfile', 'downloadFile');
	}
    
    public function downloadFile()
    {
		$user = JFactory::getUser();
		$app = JFactory::getApplication();
		$qid = $app->input->getInt('qid');
		$rid = $app->input->getInt('rid');
		
		if($user->guest || !$rid || !$qid)
		{
		    throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		$model = $this->getModel('Response');
		$download = $model->getAttachmentDetails($rid, $qid);
		
		if( empty($download) || ($download->author_id != $user->id && $download->responder_id != $user->id && !$user->authorise('core.manage', 'com_communitysurveys.category.'.$download->catid)) )
		{
		    throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}

		header("Content-Type: application/force-download");
		header("Content-Type: application/octet-stream");
		header("Content-Type: application/download");
		header("Content-Disposition: attachment; filename=".$download->filename);
			
		readfile(CS_FILE_UPLOAD_DIR.'/'.$download->filename);
		jexit();
	}
	
	public function cancel()
	{
	    $key = $this->input->getInt('id', 0);
	    $this->setRedirect(JRoute::_('index.php?option=com_communitysurveys&view=reports&layout=responses&id='.$key, false));
	}
}
?>
