<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysControllerTranslations extends JControllerAdmin
{
    protected $view_list = 'translations';

	public function __construct($config = array())
	{
		parent::__construct($config);
	}

	/**
	 * Proxy for getModel.
	 *
	 * @param   string	$name	The name of the model.
	 * @param   string	$prefix	The prefix for the PHP class name.
	 *
	 * @return  JModel
	 */
	public function getModel($name = 'Translation', $prefix = 'CommunitySurveysModel', $config = array('ignore_request' => true))
	{
		$model = parent::getModel($name, $prefix, $config);

		return $model;
	}
	
	/**
	 * Removes an item.
	 *
	 * @return  void
	 */
	public function delete()
	{
	    parent::delete();
	    
	    $survey_id = $this->input->getInt('survey_id');
	    $language_id = $this->input->getInt('language');
	    $this->setRedirect(\JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list.'&survey_id='.$survey_id.'&language='.$language_id, false));
	}
	
	/**
	 * Method to publish a list of items
	 *
	 * @return  void
	 */
	public function publish()
	{
	    parent::publish();
	    
	    $survey_id = $this->input->getInt('survey_id');
	    $language_id = $this->input->getInt('language');
	    $this->setRedirect(\JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list.'&survey_id='.$survey_id.'&language='.$language_id, false));
	}
}
